import Project
from RTCand import RTCandidate
from MRTCand import MRTCandidate
from NEATCand import NEATCandidate
from TournamentGA import TournamentGA
import Hillclimber
import Evaluation
import glob
import sys
import random
from random import uniform

def makeSinhaRegions():
	# setup template with standard regions
	regions=[[.25,.0,.5, .2],  # forehead
		 [.1, .2,.35,.2],  # left eye
		 [.45,.2,.1, .3],  # nose
		 [.55,.2,.35,.2],  # right eye
		 [.2,.45,.2, .2],  # left cheek
		 [.35,.5,.3,.15],  # top lip
		 [.6,.45,.2, .2],  # right cheek
		 [.3,.65,.4,.15],  # bottom lip
		 [.2,.65,.1,.25],  # left side chin
		 [.7,.65,.1,.25],  # right side chin
		 [.35,.85,.3,.15]] # chin
	return regions

def makeRowleyRegions():
	regions = []
	# first a 2x2 grid
	for i in range( 0, 2 ):
		for j in range( 0, 2 ):
			regions.append( [ i*0.5, j*0.5, 0.5, 0.5 ] )
	# then a 4x4 grid
	for i in range( 0, 4 ):
		for j in range( 0, 4 ):
			regions.append( [ i*0.25, j*0.25, 0.25, 0.25 ] )
	# then a 4x1 grid (horizontal lines)
	for i in range( 0, 4 ):
		regions.append( [ 0, j*0.25, 1.0, 0.25 ] )
	return regions

def makeRandomRegions(numRegions):
	rng=range(0,numRegions)
	# generated assuming (x,y) at region centre
	regions=map(lambda x: [uniform(0,1.0),uniform(0,1.0),uniform(0,1.0),uniform(0,1.0)],rng)
	# set x,y to be the top left corner
	regions=map(lambda x: [x[0]-x[2]/2.0,x[1]-x[3]/2.0,x[2],x[3]],regions)
	return regions

def bootstrapNonfaces(template,dataset,ga,numimages):
	print "bootstrapping"
	detector=Project.Detector()
	filenames=glob.glob(backgroundsDir+"/*.JPG")+glob.glob(backgroundsDir+"/*.jpg")
	filename=random.choice(filenames)
	bg=Project.Image(filename)
	detector.addTemplate(template,0)
	detector.detect(bg)
	num=detector.getNumDetected()
	print "%d false positives in %s" % (num,filename)
	if num > 0:
		indices=range(0,num)
		random.shuffle(indices)
		numimages=min(numimages,num)
		for i in range(0,numimages):
			index=indices[i]
			detection=detector.getDetected(index)
			x=detection.x-detection.size/2
			y=detection.y-detection.size/2
			#print x, " ", y, " ", detection.size
			subimage=bg.subimage(x,y,detection.size,detection.size)
			copied=Project.Image()
			copied.copy(subimage)
			copied.resize(20,20)
			dataset.addNegative(copied)
			nonfaceimages.append(copied)
			#subimage=subimage.resize(20,20)
			#dataset.addNegative(subimage)
			#nonfaceimages.append(subimage)
		ga.invalidate()
	print "%d negatives" % dataset.getNumNegatives()

def createRTPopulation(popSize,fitnessFunction,numRatios,mutationSize,regionsFn):
	print "Using RTCand"
	regions=regionsFn()
	child=RTCandidate(fitnessFunction,mutationSize,regions,numRatios)
	population=[]
	for i in xrange(0,popSize):
		indiv=RTCandidate(fitnessFunction,mutationSize,regions,numRatios)
		population.append(indiv)
	return (child,population)

def createMRTPopulation(popSize,fitnessFunction,numRatios,mutationSize,regionsFn,regionMutationRate):
	print "Using MRTCand"
	regions=regionsFn()
	child=MRTCandidate(fitnessFunction,mutationSize,regions,numRatios,regionMutationRate)
	population=[]
	for i in xrange(0,popSize):
		indiv=MRTCandidate(fitnessFunction,mutationSize,regions,numRatios,regionMutationRate)
		population.append(indiv)
	return (child,population)

def createNEATPopulation(popSize,fitnessFunction,mutationSize,regionsFn,numRatios,regionMutationRate):
	print "Using NEATCand"
	regions=regionsFn()
	child=NEATCandidate(fitnessFunction,mutationSize,regions,numRatios,regionMutationRate,addRegionMutateRate,addRatioMutateRate)
	population=[]
	for i in xrange(0,popSize):
		indiv=NEATCandidate(fitnessFunction,mutationSize,regions,numRatios,regionMutationRate,addRegionMutateRate,addRatioMutateRate)
		population.append(indiv)
	return (child,population)

# default parameters
candidate="rt"
filenamesuffix=""
outputDirectory="Output"
numRatios=20
numRegions=11
mutationSize=0.1
popSize=1000
tournamentSize=2
recombination=0.1
mutation=0.9
replace=0.01
iterations=popSize*100
epochLength=10000
hillclimbFn=None#Hillclimber.hillclimb
facesDir="faces-aligned"
nonfacesDir="nonfaces"
backgroundsDir="backgrounds"
numBootstrapImages=200
positiveWeighting=0.5
addRegionMutateRate=0.01
addRatioMutateRate=0.01
regionsFn=makeSinhaRegions
regionMutationRate=0.01

ident=""

for arg in sys.argv[1:]:
	if arg.startswith( "-params=" ):
		params=open(arg[len("-params="):])
		for line in params.readlines():
			exec( line )
	elif arg.startswith( "-ident=" ):
		ident=arg[len("-ident="):]

filenamesuffix=filenamesuffix+ident
print "candidate=",candidate
print "filenamesuffix=",filenamesuffix

print "reading images"

#faces=glob.glob("faces-normed/*.jpg")
faces=glob.glob(facesDir+"/*.jpg")
print "%d faces" % len( faces )
nonfaces=glob.glob(nonfacesDir+"/*.jpg")
print "%d non-faces" % len( nonfaces )

dataset=Project.DataSet()
print "reading faces"
# must keep hold of the images to avoid garbage collection
faceimages=map( lambda x: Project.Image( x ), faces )
for face in faceimages:
	dataset.addPositive(face)

print "reading non-faces"
nonfaceimages=map( lambda x: Project.Image( x ), nonfaces )
for nonface in nonfaceimages:
	dataset.addNegative(nonface)
print "images read"

#nonfaceimages=[]

fitnessFunction=Evaluation.Function(dataset,positiveWeighting)

if candidate == "rt":
	child,population=createRTPopulation(popSize,fitnessFunction,numRatios,mutationSize,regionsFn)
elif candidate == "mrt":
	child,population=createMRTPopulation(popSize,fitnessFunction,numRatios,mutationSize,regionsFn,regionMutationRate)
elif candidate == "neat":
	child,population=createNEATPopulation(popSize,fitnessFunction,mutationSize,regionsFn,numRatios,regionMutationRate)
	

ga=TournamentGA(child,population,tournamentSize,recombination,mutation,replace,hillclimbFn)

print "starting"

fitnessfile=open(outputDirectory+"/"+"fitness"+filenamesuffix+".csv", "w")
fitnessfile.write("Step,Best Fitness,Average Fitness,Fitness Variance,Positives,Total Positives,Negatives,Total Negatives\n")

print "best at start: %f" % ga.best().fitness()

currentFitness=-1.0

for i in xrange(0,iterations):
	ga.step()
	if i % epochLength == 0 and i != 0:
		bootstrapNonfaces(ga.best().getTemplate(),dataset,ga,numBootstrapImages)
	
	best=ga.best()
	if currentFitness != best.fitness():
		currentFitness=best.fitness()
		avg = ga.averagefitness()
		var = ga.fitnessvariance()
		template=best.getTemplate()
		positives=dataset.matchPositives(template)
		negatives=dataset.matchNegatives(template)
		totalpositives=dataset.getNumPositives()
		totalnegatives=dataset.getNumNegatives()
		fitnessfile.write( ("%d,%f,%f,%f,%d,%d,%d,%d\n" % (i,currentFitness,avg,var,positives,totalpositives,negatives,totalnegatives)) )
		print "best at %d: %f %f (%d/%d,%d/%d)" % (i,best.fitness(),avg,positives,totalpositives,negatives,totalnegatives)

fitnessfile.close();

best=ga.best()
print best
template=best.getTemplate()
template.save(outputDirectory+"/"+"best-template"+filenamesuffix+".txt")
templateImg=Project.Image(200,200)
templateImg.set(0.0)
template.draw(templateImg)
templateImg.save(outputDirectory+"/"+"best-template"+filenamesuffix+".jpg")

print "%d positives %d false positives" % (dataset.matchPositives(template),dataset.matchNegatives(template))

print "done"

#for name,img in zip(faces,faceimages):
#	if not template.matches(img):
#		print name + " did not match"

#for name,img in zip(nonfaces,nonfaceimages):
#	if template.matches(img):
#		print name + " matched"
