from Project import Image,RatioTemplate,Detector
from sys import argv
from glob import glob
from random import choice,random

def loadImage(filename):
	img=Image(filename)
	return img

def loadTemplate(filename):
	template=RatioTemplate()
	template.load(filename)
	return template

def matchImage(image,detector):
	detector.detect(image)
	return detector.getNumDetected()

def numMatches(images,detector):
	matches=map( lambda image: matchImage(image,detector), images )
	return reduce( lambda x,y: x+y, matches )

def testDetectorPrecisionRecall(detector,faces,nonfaces):
	TP=numMatches(faces,detector)
	FP=numMatches(nonfaces,detector)
	P=len(faces)
	N=len(nonfaces)
	TN=N-FP
	accuracy=(TP+TN)/float(P+N)
	if TP+FP != 0.0:
		precision=TP/float(TP+FP)
	else:
		precision=1.0
	recall=TP/float(P)
	return (precision,recall)

def groupNames(groups):
	files = ""
	for group in groups:
		filesgroup = ""
		for template in group:
			i=templates.index(template)
			filesgroup += (filenames[i] + " ")
		files += "\"%s\" " % filesgroup.strip()
	return files.strip()

def mutate(groups):
	newgroups=[]
	for group in groups:
		newgroup=[]
		for template in group:
			if random() < mutateRate:
				newgroup.append(choice(templates))
			else:
				newgroup.append(template)
		newgroups.append(newgroup)
	return newgroups

print "Loading Templates"
filenames=argv[1:]
templates=map( loadTemplate, filenames )
print len(templates), "Templates"

print "Loading Images"
faces=map( loadImage, glob( "faces-aligned/*.jpg" )+glob( "ATTFaces-aligned/*.jpg" ) )
print len(faces), "Faces"
nonfaces=map( loadImage, glob( "nonfaces?/*.jpg" ) )
print len(nonfaces), "Non-Faces"

# two groups of two
#groups=[[choice(templates),choice(templates),choice(templates)],[choice(templates),choice(templates),choice(templates)]]
groups=[[choice(templates),choice(templates),choice(templates)]]
num=0
for group in groups:
	num += len(group)
mutateRate=1.0/float(num)

detector=Detector()

precision,recall=testDetectorPrecisionRecall(detector,faces,nonfaces)
print "start",precision,recall
bestscore=precision*(10.0 + recall)

for n in xrange(0,4000):
	detector.clearTemplates()
	newgroups=mutate(groups)
	for i,group in zip(range(len(newgroups)),newgroups):
		for template in group:
			detector.addTemplate(template,i)
	precision,recall=testDetectorPrecisionRecall(detector,faces,nonfaces)
	score=precision*(10.0 + recall)
	if score > bestscore:
		groups=newgroups
		bestscore=score
		print n,precision,recall



print groupNames(groups)

