import sys
from Project import Image, RatioTemplate, Detector, CVWindow
from re import split
from os.path import basename

def drawDetection(image,detection):
	x1=detection.x-detection.size/2
	y1=detection.y-detection.size/2
	x2=detection.x+detection.size/2
	y2=detection.y+detection.size/2
	#print x1,y1,x2,y2
	image.rect(255,x1,y1,x2,y2)
	image.rect(0.0,x1-1,y1-1,x2+1,y2+1)
	#image.line( 1.0, x1, y1, x1, y2 )
	#image.line( 1.0, x1, y2, x2, y2 )
	#image.line( 1.0, x2, y2, x2, y1 )
	#image.line( 1.0, x2, y1, x1, y1 )
	#image.line( 0.0, x1-1, y1-1, x1-1, y2+1 )
	#image.line( 0.0, x1-1, y2+1, x2+1, y2+1 )
	#image.line( 0.0, x2+1, y2+1, x2+1, y1-1 )
	#image.line( 0.0, x2+1, y1-1, x1-1, y1-1 )
	#print "drawn"

#print sys.argv

templateGroups = []
imagesfiles = []
savetodir = False
savedir = ""

for arg in sys.argv[1:]:
	if arg.lower().endswith( ".jpg" ):
		imagesfiles.append( arg )
	elif arg.startswith( "-scale:" ):
		scale=float(arg[len("-scale:"):])
		detector.setScaleFactor(scale)
		print "Scale=%f" % scale
	elif arg.startswith( "-save:" ):
		savetodir = True
		savedir = arg[len("-save:"):]
	else:
		templateGroups.append( arg )

detector=Detector()
templates=[]
for i,group in zip(range(0,len(templateGroups)),templateGroups):
	filenames=split("\s+",group)
	for filename in filenames:
		print "Group %d: %s" % (i,filename)
		template=RatioTemplate()
		template.load(filename)
		templates.append(template)
		detector.addTemplate(template,i)

print len(templates), "templates loaded"

images=[]
windows=[]

for filename in imagesfiles:
	image=Image(filename)
	imagecopy=Image(image)
	print filename
	detector.detect(image)
	print "%d detected" % detector.getNumDetected()
	#detector.drawDetections(imagecopy)
	#print "coalescing"
	#detector.coalesceDetections(image.width(),image.height(),10,10)
	#print "grouping"
	#detector.groupOverlapping()
	#print "%d detected" % detector.getNumDetected()
	detector.drawDetections(image)
	
	
	#wincopy=CVWindow(filename+"-Not-Coalesced")
	
	
	if savetodir:
		image.save( savedir + "/" + basename(filename) )
	else:
		images.append(image)
		win=CVWindow(filename+"-Coalesced")
		windows.append(win)
		win.show(image)
	#images.append(imagecopy)
	#windows.append(wincopy)
	#wincopy.show(imagecopy)


while not savetodir:
	for image, window in zip(images,windows):
		window.show(image)
