from Project import Image, Detector, RatioTemplate, CVWindow
from sys import argv
from re import split

# uses the Camera class which may not have been compiled in
try:
	from Project import Camera
except:
	print "The Project module needs to be recompiled with PhilipsCamera support"
	import sys
	sys.exit(1)

cam=Camera("/dev/video0")
cam.setResolution( 160, 120 )
img=Image(160,120)
win=CVWindow("Camera")
templates=[]
detector=Detector()
templateGroups = filter( lambda x: not x.startswith("-"), argv[1:])
options = filter( lambda x: x.startswith( "-" ), argv[1:])
for i,group in zip(range(0,len(templateGroups)),templateGroups):
	filenames=split("\s+",group)
	for filename in filenames:
		print "Group %d: %s" % (i,filename)
		template=RatioTemplate()
		template.load(filename)
		templates.append(template)
		detector.addTemplate(template,i)


try:
	index=options.index( "-save" )
	saveimages=True
except:
	saveimages=False

i=0
while True:
	cam.capture( img )
	detector.detect( img )
	detector.groupOverlapping()
	detector.drawDetections(img)
	win.show( img )
	if saveimages:
		name = "webcamout/image%d.jpg" % i
		img.save(name)
		i=i+1
	#print "captured"
