import random

#note: maximies fitness
class TournamentGA:
	def __init__( self, child, population, tournamentSize, recombination, mutation, replace, hillclimbFn=None ):
		self.child          = child
		self.population     = population
		self.tournamentSize = tournamentSize
		self.recombination  = recombination
		self.mutation       = mutation
		self.replace        = replace
		self.hillclimbFn    = hillclimbFn
	
	def best(self):
		best_indiv=self.child
		for indiv in self.population:
			if best_indiv.fitness() < indiv.fitness():
				best_indiv=indiv
		return best_indiv
	
	def averagefitness(self):
		sum=0.0
		for indiv in self.population:
			sum += indiv.fitness()
		return sum/len(self.population)
	
	def fitnessvariance(self):
		mu=self.averagefitness()
		sum=0.0
		for indiv in self.population:
			diff = indiv.fitness()-mu
			sum += (diff*diff)
		return sum/len(self.population)
	
	def invalidate(self):
		self.child.invalidate()
		for indiv in self.population:
			indiv.invalidate()
	
	def tournament( self ):
		indiv1 = random.choice( self.population )
		for i in xrange( 0, self.tournamentSize-1 ):
			indiv2 = random.choice( self.population )
			if indiv1.fitness() < indiv2.fitness():
				indiv1 = indiv2
		return indiv1
	
	def step( self ):
		parent1 = self.tournament()
		self.child.copy( parent1 )
		if random.uniform( 0, 1 ) < self.recombination:
			parent2 = self.tournament()
			self.child.recombine( parent2 )
		if random.uniform( 0, 1 ) < self.mutation:
			self.child.mutate()
		if self.hillclimbFn != None:
			self.hillclimbFn(self.child, 10 )
		index = random.choice( range( 0, len( self.population ) ) )
		replace = self.population[ index ]
		if self.child.fitness() > replace.fitness() or random.uniform( 0, 1 ) < self.replace:
			self.population[ index ] = self.child
			self.child = replace
