#ifndef __RatioTemplate_H__
#define __RatioTemplate_H__

#include "Image.h"


class Region {
public:
	double x, y, width, height;
	int ix, iy, iwidth, iheight;
};
	
class Ratio {
public:
	double threshold;
	int region1, region2;
	double importance;
};

class RatioTemplate {

public:
	
	// TODO make this setup for a size at the start
	// so we can then normalise the template we
	// match against
	RatioTemplate();
	~RatioTemplate();
	
public:
	int getNumRegions() const { return numRegions_; };
	void setNumRegions( int num );
	
	int getNumRatios() const { return numRatios_; };
	void setNumRatios( int num );
	
	
	void setRegion( int index, double x, double y, double width, double height );
	Region getRegion( int i ) const { return regions_[ i ]; };
	void setRatio( int index, double threshold, int region1, int region2, double importance );
	Ratio getRatio( int i ) const { return ratios_[ i ]; };
	
	void resetUsedRegions();
	void setImageSize( int width, int height );
public:
	bool matches( const Image& img ) const;
	bool matches( const CvArr* image, int width, int height ) const;

public:
	void draw( Image& img ) const;

public:
	void save( const char* name ) const;
	void load( const char* name );

private:
	Region* regions_;
	bool* used_;
	int numRegions_;
	Ratio* ratios_;
	int numRatios_;

};

#endif // __RatioTemplate_H__
