import Project
from Cand import Candidate
from random import choice,uniform,gauss
from copy import deepcopy


class RTCandidate(Candidate):
	def __init__(self,fitnessFunction,mutationSize,regions,numRatios):
		Candidate.__init__(self,fitnessFunction,mutationSize,regions)
		self.template.setNumRatios(numRatios)
		regions=range(0,self.template.getNumRegions())
		rng=range(0,numRatios)
		self.used      =map( lambda x: choice([False,True]),rng)
		self.threshold =map( lambda x: uniform(0,1.0),rng)
		self.region1   =map( lambda x: choice(regions),rng)
		self.region2   =map( lambda x: choice(regions),rng)
		self.importance=map( lambda x: uniform(0,1.0),rng)
		self.invalidate()
	
	def initialiseTemplate(self,template):
		template.resetUsedRegions()
		used=0
		for i in xrange(0,len(self.used)):
			# is used and not between different regions
			if self.used[i] and self.region1[i] != self.region2[i]:
				used=used+1
		template.setNumRatios(used)
		index=0
		for i in xrange(0,len(self.used)):
			# is used and not between different regions
			if self.used[i] and self.region1[i] != self.region2[i]:
				threshold =1.0+self.threshold[i]
				#threshold =self.threshold[i]
				region1   =self.region1[i]
				region2   =self.region2[i]
				importance=self.importance[i]
				template.setRatio(index,threshold,region1,region2,importance)
				index=index+1
	
	# copy the other candidate into this one
	def copy(self,other):
		self.used      =deepcopy(other.used)
		self.threshold =deepcopy(other.threshold)
		self.region1   =deepcopy(other.region1)
		self.region2   =deepcopy(other.region2)
		self.importance=deepcopy(other.importance)
		Candidate.copy(self,other)
	
	def mutateRatioRegions(self):
		pointRate=1.0/len(self.region1)
		indices=range(0,len(self.region1))
		for i,r1,r2 in zip(indices,self.region1,self.region2):
			if uniform(0,1) < pointRate:
				if uniform(0,1) < 0.5:
					r1=self.selectNeighbouringRegion(r2)
				else:
					r2=self.selectNeighbouringRegion(r1)
				self.region1[i]=r1
				self.region2[i]=r2
	
	# apply a single mutation
	def mutate(self):
		pointRate=0.5
		if uniform(0,1) < pointRate:
			self.used=self.mutateAllele(self.used,[False,True])
		if uniform(0,1) < pointRate:
			self.threshold=self.mutateGauss(self.threshold)
		if uniform(0,1) < pointRate:
			self.mutateRatioRegions()
		if uniform(0,1) < pointRate:
			self.importance=self.mutateGauss(self.importance)
		Candidate.mutate(self)
	
	# discrete uniform crossover
	def recombine(self,other):
		for i in xrange(0,len(self.used)):
			if uniform(0,1) < 0.5:
				self.used[i]      =other.used[i]
				self.threshold[i] =other.threshold[i]
				self.region1[i]   =other.region1[i]
				self.region2[i]   =other.region2[i]
				self.importance[i]=other.importance[i]
		Candidate.recombine(self,other)
	
#	def __str__(self):
#		return "Candidate:"+str(self.ratios)
