import Project
from Cand import Candidate
from random import choice,uniform,gauss
from copy import deepcopy

regionTagNum = 4

def nextRegionTag():
	global regionTagNum
	num=regionTagNum
	regionTagNum=regionTagNum+1
	return num

def mutateGauss(size,value):
	return max(0.0,min(1.0,value+ size*gauss(0,1)))

class Ratio:
	# a ratio's tag is defined by the regions
	# it connects
	def __init__(self,used,region1,region2,threshold,importance):
		self.used=used
		self.region1Tag=region1.tag
		self.region2Tag=region2.tag
		self.threshold =threshold
		self.importance=importance
		self.tag=str(self.region1Tag)+"->"+str(self.region2Tag)
	
	def copy(self,other):
		self.region1Tag=other.region1Tag
		self.region2Tag=other.region1Tag
		self.threshold =other.threshold
		self.importance=other.importance
		self.tag=other.tag
	
	def mutate(self,mutationSize,pointRate):
		if uniform(0,1) < pointRate:
			self.used=choice([True,False])
		self.threshold=mutateGauss(mutationSize,self.threshold)
		self.importance=mutateGauss(mutationSize,self.importance)

class Region:
	def __init__(self,tag,x,y,width,height):
		self.tag=tag
		self.x=x
		self.y=y
		self.width =width
		self.height=height
	
	def copy(self,other):
		self.tag=other.tag
		self.x=other.x
		self.y=other.y
		self.width =other.width
		self.height=other.height
	
	def mutate(self,mutationSize,mutateRate):
		self.x=mutateGauss(mutationSize,self.x)
		self.y=mutateGauss(mutationSize,self.y)
		self.width=mutateGauss(mutationSize,self.width)
		self.height=mutateGauss(mutationSize,self.height)

class NEATCandidate(Candidate):
	def __init__(self,fitnessFunction,mutationSize,regions,numRatios,regionMutationRate,addRegionMutateRate,addRatioMutateRate):
		Candidate.__init__(self,fitnessFunction,mutationSize,regions)
		self.regionMutationRate=regionMutationRate
		self.addRegionMutateRate=addRegionMutateRate
		self.addRatioMutateRate =addRatioMutateRate
		self.template=Project.RatioTemplate()
		self.regions = {}
		self.ratios  = {}
		for tag,region in zip( range(0,len(regions)), regions):
			x=region[0]
			y=region[1]
			w=region[2]
			h=region[3]
			self.regions[tag]=Region(tag,x+w/2.0,y+h/2.0,w,h)
		
		regions=self.regions.values()
		for i in range(0,numRatios):
			ratio=Ratio(choice([True,False]),choice(regions),choice(regions),uniform(0,1),uniform(0,1))
			self.ratios[ratio.tag]=ratio
		self.invalidate()
	
	def initialiseTemplate(self,template):
		template.resetUsedRegions()
		# setup regions
		regions=self.regions.values()
		template.setNumRegions(len(regions))
		for i in xrange(0,len(regions)):
			region=regions[i]
			x,y=region.x,region.y
			width,height=region.width,region.height
			left=x-width/2
			top=y-height/2
			right=x+width/2
			bottom=y+height/2
			left=max(0,left)
			top=max(0,top)
			right=min(1.0,right)
			bottom=min(1.0,bottom)
			template.setRegion( i, left, top, right-left, bottom-top )
		# setup ratios
		ratios=self.ratios.values()
		usedratios=[]
		for ratio in ratios:
			if ratio.used:
				usedratios.append(ratio)
		template.setNumRatios(len(usedratios))
		for index,ratio in zip(range(0,len(usedratios)),usedratios):
			r1=self.regions[ratio.region1Tag]
			r2=self.regions[ratio.region2Tag]
			r1Index=regions.index(r1)
			r2Index=regions.index(r2)
			threshold=1.0+ratio.threshold
			importance=ratio.importance
			template.setRatio(index,threshold,r1Index,r2Index,importance)
	
	# copy the other candidate into this one
	def copy(self,other):
		self.regions = deepcopy(other.regions)
		self.ratios  = deepcopy(other.ratios)
		Candidate.copy(self,other)
	
	def doPointMutate(self):
		loci=self.regions.values()
		if uniform(0,1) < self.regionMutationRate:
			loci = self.ratios.values()
		totalLen=len(loci)
		pointRate=1.0/totalLen
		for locus in loci:
			locus.mutate(self.mutationSize,pointRate)
	
	def addRegionMutate(self):
		tag=nextRegionTag()
		# duplicate an existing region
		existing=choice(self.regions.values())
		region=Region(tag,existing.x,existing.y,existing.width,existing.height)
		self.regions[tag]=region
	
	def addRatioMutate(self):
		regions=self.regions.values()
		r1=choice(regions)
		r1Index=regions.index(r1)
		r2Index=self.selectNeighbouringRegion(r1Index)
		r2=regions[r2Index]
		ratio=Ratio(choice([True,False]),r1,r2,uniform(0,1),uniform(0,1))
		self.ratios[ratio.tag]=ratio
	
	# apply a single mutation
	def mutate(self):
		if uniform(0,1) < self.addRegionMutateRate:
			self.addRegionMutate()
		if uniform(0,1) < self.addRatioMutateRate:
			self.addRatioMutate()
		self.doPointMutate()
		Candidate.mutate(self)
	
	# find regions/ratios that share the same tags
	# and copy them with a certain probability
	def combineTagged(self,tagged1,tagged2):
		tags=tagged1.keys()
		for tag in tags:
			if tagged2.has_key(tag) and uniform(0,1) < 0.5:
				tagged1[tag].copy(tagged2[tag])
	
	# discrete uniform crossover
	def recombine(self,other):
		self.combineTagged(self.regions,other.regions)
		self.combineTagged(self.ratios, other.ratios)
		Candidate.recombine(self,other)
	
#	def __str__(self):
#		return "Candidate:"+str(self.ratios)
