from RTCand import RTCandidate
from random import uniform
from copy import deepcopy
from math import sqrt

class MRTCandidate(RTCandidate):
	def __init__(self,fitnessFunction,mutationSize,regions,numRatios,regionMutationRate):
		RTCandidate.__init__(self,fitnessFunction,mutationSize,regions,numRatios)
		self.regionMutationRate=regionMutationRate
		self.x      = []
		self.y      = []
		self.width  = []
		self.height = []
		for region in regions:
			x=region[0]
			y=region[1]
			w=region[2]
			h=region[3]
			self.x.append(x+w/2.0)
			self.y.append(y+h/2.0)
			self.width.append(w)
			self.height.append(h)
	
	def initialiseTemplate(self,template):
		RTCandidate.initialiseTemplate(self,template)
		num=len(self.x)
		self.template.setNumRegions(num)
		for i in xrange(0,num):
			x=self.x[i]
			y=self.y[i]
			#print x, " " ,y
			width=self.width[i]
			height=self.height[i]
			left=x-width/2
			top=y-height/2
			right=x+width/2
			bottom=y+height/2
			left=max(0,left)
			top=max(0,top)
			right=min(1.0,right)
			bottom=min(1.0,bottom)
			#print left,right,top,bottom
			#print self.template.getNumRegions(),i,right,bottom
			self.template.setRegion( i, left, top, right-left, bottom-top )
	
	def copy(self,other):
		RTCandidate.copy(self,other)
		self.x     =deepcopy(other.x)
		self.y     =deepcopy(other.y)
		self.width =deepcopy(other.width)
		self.height=deepcopy(other.height)
	
	def mutate(self):
		# most of the time we want to just
		# mutate the ratios
		RTCandidate.mutate(self)
		if uniform(0,1) < self.regionMutationRate:
			pointRate=0.25
			if uniform(0,1) < pointRate:
				self.x=self.mutateGauss(self.x)
			if uniform(0,1) < pointRate:
				self.y=self.mutateGauss(self.y)
			if uniform(0,1) < pointRate:
				self.width=self.mutateGauss(self.width)
			if uniform(0,1) < pointRate:
				self.height=self.mutateGauss(self.height)
		self.invalidate()
	
	def recombine(self,other):
		RTCandidate.recombine(self,other)
		for i in xrange(0,len(self.x)):
			if uniform(0,1) < 0.5:
				self.x[i]      = other.x[i]
				self.y[i]      = other.y[i]
				self.width[i]  = other.width[i]
				self.height[i] = other.height[i]
		self.invalidate()

