#ifndef __Image_H__
#define __Image_H__

#include "rand-util.h"

#include "opencv/cv.h"


class Image {

public:
	enum TYPE { IPLIMAGE, MATRIX };

public:
	static unsigned int DEPTH;

public:
	Image();
	Image( int w, int h, int depth = DEPTH );
	Image( const Image& img );
	Image( const Image& img, int x, int y, int width, int height );
	Image( const char* filename );
	~Image();

public:
	void load( const char* filename );
	void save( const char* filename ) const;

public:

	int width()  const { return w_; };
	int height() const { return h_; };

	double pixel( int i, int j ) const { return cvGetReal2D( image_, j, i ); };
	void setpixel( int i, int j, double value ) { cvSetReal2D( image_, j, i, value ); };

	      CvArr* image()       { return image_; };
	const CvArr* image() const { return image_; };
		
	TYPE type() const { return type_; };
	
	double avg() const;
	double sum() const;
	
	double moment()  const;
	double momentx() const;
	double momenty() const;
	
	Image subimage( int x, int y, int width, int height ) const;
	
public:
	Image& set( double value );
	Image& copy( const Image& img );
	Image& copyCvArr( const CvArr* image );
	
public:
	Image& diff( const Image& img );
	Image& blur();
	Image& resize( int width, int height );
	Image& scalePyramidDown();
	Image& scalePyramidUp();
	Image& normalise();
	
public:
	void line( double value, int x1, int y1, int x2, int y2 );
	void text( const char* text, double color, int x, int y );
	void rect( double value, int x1, int y1, int x2, int y2 );
	
protected:
	void release_image();

protected:
	CvArr* image_;
	int w_;
	int h_;
	TYPE type_;
	
private:
	void operator=( const Image& rhs );
};


#endif // __Image_H__
