from random import gauss

def mutateGauss(value,stepSize):
	value=value+stepSize*gauss(0,1)
	value=max(0.0,min(1.0,value))
	return value
	
def hillclimb(candidate,numiter,stepSize=0.1):
	for i in xrange(0,numiter):
		params=candidate.hillclimbingParameters()
		mutated=map(lambda x: mutateGauss(x,stepSize),params)
		fitness=candidate.fitness()
		candidate.setHillclimbingParameters(mutated)
		if fitness > candidate.fitness():
			# don't accept the change if it makes fitness worse
			candidate.setHillclimbingParameters(params)
