#ifndef __Detector_H__
#define __Detector_H__

#include "RatioTemplate.h"
#include "Image.h"
#include "stdvector.h"

class Detection {
public:
	Detection( int nx, int ny, int nsize, int ncount )
	 : x(nx), y(ny), size(nsize), count(ncount) {};
public:
	bool overlaps( const Detection& detection ) const;
public:
	int x, y, size, count;
};

class Detector {

public:
	Detector();

public:
	double getScaleFactor() const { return scaleFactor_; };
	void setScaleFactor( double scaleFactor ) { scaleFactor_ = scaleFactor; };

	int getNumDetected() const { return detected_.size(); };
	Detection getDetected( int i ) const { return detected_[ i ]; };

	void addTemplate( const RatioTemplate& ratioTemplate, unsigned int group );

	void clearTemplates();

public:
	void detect( const Image& input );
	void coalesceDetections( int width, int height, int neighbourhood, unsigned int threshold  );
	void groupOverlapping();
	
public:
	void drawDetections( Image& image ) const;
protected:
	void detect( const Image& originalImage, Image& input, double scale );
	
private:
	stdvector<Detection> detected_;
	stdvector< stdvector<const RatioTemplate*> > templates_;
	double scaleFactor_;

};

#endif // __Detector_H__
