#ifndef __DataSet_H__
#define __DataSet_H__

#include "RatioTemplate.h"
#include "Image.h"
#include "stdvector.h"

class DataSet {

public:
	unsigned int getNumPositives() const { return positives_.size(); };
	unsigned int getNumNegatives() const { return negatives_.size(); };

	void addPositive( const Image& image );
	void addNegative( const Image& image );

	void clear();

public:
	int matchPositives( const RatioTemplate& ratioTemp ) const;
	int matchNegatives( const RatioTemplate& ratioTemp ) const;

private:
	stdvector<const Image*> positives_;
	stdvector<const Image*> negatives_;
};

#endif // __DataSet_H__
