#include "DataSet.h"

void DataSet::addPositive( const Image& image ) {
	positives_.push_back( &image );
}

void DataSet::addNegative( const Image& image ) {
	negatives_.push_back( &image );
}

void DataSet::clear() {
	positives_.clear();
	negatives_.clear();
}

int DataSet::matchPositives( const RatioTemplate& ratioTemp ) const {
	int matches = 0;
	for ( unsigned int i = 0; i < positives_.size(); i++ ) {
		const Image* image = positives_[ i ];
		if ( ratioTemp.matches( *image ) )
			matches++;
	}
	return matches;
}

int DataSet::matchNegatives( const RatioTemplate& ratioTemp ) const {
	int matches = 0;
	for ( unsigned int i = 0; i < negatives_.size(); i++ ) {
		const Image* image = negatives_[ i ];
		if ( ratioTemp.matches( *image ) )
			matches++;
	}
	return matches;
}
