#include "Camera.h"

Camera::Camera(const char* device)
{
	camera_.openDevice(device);
	camera_.setGain(-1);
}

Camera::~Camera() {
	camera_.closeDevice();
}


void Camera::setResolution( int width, int height ) {
	camera_.setResolution( width, height );
}

void Camera::capture( Image& img ) {
	camera_.grabImage();
	unsigned char* pCam = camera_.getGreyPointer();
	unsigned char* pData = NULL;
	CvArr* image = img.image();
	int step = img.width();
	CvSize size;
	cvGetRawData( image, &pData, &step, &size );
	if ( pData != NULL ) {
		memcpy( pData, pCam, sizeof( unsigned char )*img.width()*img.height() );
	}
	else
		assert( false );
}
