#include "CVWindow.h"

#include "opencv/cv.h"
#include "opencv/highgui.h"


CVWindow::CVWindow( const char* windowName )
 : windowName_( NULL )
{
	int len = strlen( windowName );
	windowName_ = new char[ len+1 ];
	strcpy( windowName_, windowName );
	cvNamedWindow( windowName_, CV_WINDOW_AUTOSIZE );
}

CVWindow::~CVWindow() {
	cvDestroyWindow( windowName_ );
	delete[] windowName_;
}

void CVWindow::show( const Image& img ) const {
	cvResizeWindow( windowName_, 2*img.width(), 2*img.height() );
	cvShowImage( windowName_, img.image() );
	cvWaitKey(10); // small wait to let other threads cope
}
