/*
 * Created on Oct 19, 2003
 *
 */
package proj1.simulator.physics;

// TODO reference chris heckers physics tutorials http://www.d6.com/

/**
 * @author john
 *
 */
public class Body {
	private float mass = 1.0f;
	private float momentOfInertia = 25.0f;
	
	private State currentState = new State();
	private State nextState    = new State();
	private State state        = currentState;
	
	private final Vector2d accumForces = new Vector2d();
	private float accumTorque = 0.0f;
	
	// used as a temporary variable in calculations 
	private final Vector2d v = new Vector2d();
	
	
	private float linearDamping = 0.1f;
	private float angularDamping = 2.0f;
	
	public float getMass() {
		return mass;
	}
	
	public void setMass( float mass ) {
		this.mass = mass;
	}
        
	public void setMomentOfInertia( float momentOfInertia ) {
	    this.momentOfInertia = momentOfInertia;
	}
	
	public float getMomentOfInertia() {
	    return momentOfInertia;
	}
        
	public Vector2d getPosition() {
		return state.position;
	}
	
	public void setPosition( Vector2d v ) {
		state.position.set( v );
	}
	
	public float getAngle() {
		return state.angle;
	}
	
	public void setAngle( float angle ) {
		state.angle = angle;
	}
	
	public void applyForce( float x, float y, float fx, float fy ) {
		accumForces.add( fx, fy );
		
		float rx = (x - state.position.x);
		float ry = (y - state.position.y);

		accumTorque -= (-ry*fx + rx*fy);
	}
	
	public void applyImpulse( float x, float y, float ix, float iy ) {
		state.momentum.add( ix, iy );
		
		float rx = (x - state.position.x);
		float ry = (y - state.position.y);
		
		state.angularMomentum -= (-ry*ix + rx*iy);
	}
	
	public void integrate( float dt ) {
                
		// integrate
		State scurr = currentState;
		State snext = nextState;
		
		// TODO add angular friction (at vehicle level, acting at motor locations)
		// TODO allow specification of a friction constant
		Vector2d fr = v.divide( scurr.momentum, mass ).multiply( -1 );
		applyForce( scurr.position.x, scurr.position.y, fr.x, fr.y );
		        
		// pos = pos + dt*(mom/mass)
		snext.position.add( scurr.position, v.multiply( dt/mass, scurr.momentum ) );
		// mom = mom + dt*force
		snext.momentum.add( scurr.momentum, v.multiply( dt, accumForces ) );
		
		// mom = mom - dt*damping*mom
		snext.momentum.subtract( v.multiply( dt*linearDamping, snext.momentum ) );
		        
		snext.angle = scurr.angle + dt*scurr.angularMomentum/momentOfInertia;
		snext.angularMomentum = scurr.angularMomentum + dt*accumTorque;		
		        
		snext.angularMomentum = snext.angularMomentum - dt*angularDamping*snext.angularMomentum;
		        
		state = nextState;
	}
	
	public void update() {
		nextState = currentState;
		currentState = state;
		accumForces.zero();
		accumTorque = 0.0f;
	}

	public float momentum() {
		return state.momentum.magnitude();
	}
	
	public float speed() {
		return momentum()/mass;
	}
	
	public Vector2d calculateVelocity( Vector2d v ) {
		return v.divide( state.momentum, mass );
	}

	public Vector2d getMomentum() {
		return state.momentum;
	}
	
	public Vector2d calculatePointMomentum( Vector2d p, Vector2d mom ) {
		
		Vector2d pos = state.position;
		
		float rx = (p.x - pos.x);
		float ry = (p.y - pos.y);

		mom.x = state.momentum.x +  state.angularMomentum*ry;
		mom.y = state.momentum.y + -state.angularMomentum*rx;
		
		return mom;
	}

	/**
	 * @author john
	 *
	 */
	public class State {
		public final Vector2d position = new Vector2d();
		public final Vector2d momentum = new Vector2d();
		
		public float angle = 0.0f;
		public float angularMomentum = 0.0f;
		
	}
}
