/*
 * SensorGroup.java
 *
 * Created on 27 October 2003, 12:29
 */

package proj1.simulator;

import proj1.simulator.physics.*;

import java.util.List;
import java.util.ArrayList;

/**
 * A collection of sensors at a particular location on a vehicle.
 * @author  msc37jxm
 */
public class SensorGroup {
	private List sensors = new ArrayList();
	
	private float angle;
	private float distance;
	private float fieldOfView;
	
	private float maxRange = 32;
	
	private Vehicle vehicle = null;
	
	/** Creates a new instance of SensorGroup */
	public SensorGroup( Vehicle vehicle, float angle, float fieldOfView ) {
		this.vehicle       = vehicle;
		this.angle         = angle;
		this.fieldOfView = fieldOfView;
	}
	
	/** Angle on the vehicles body. **/
	public float getAngle() {
		return angle;
	}
	
	public float getDistance() {
		return distance;
	}
	
	public float getFieldOfView() {
		return fieldOfView;
	}
	
	public float getMaxRange() {
		return maxRange;
	}
	
	private float normalise( float angle ) {
		// between Pi and -Pi
		angle = angle % (float)(2*Math.PI);
		if ( angle > Math.PI )
			angle -= (float)(2*Math.PI);
		if ( angle < -Math.PI )
			angle += (float)(2*Math.PI);
		return angle;
	}
	
	private boolean angleWithin( float angle1, float angle2, float range ) {
		
		//System.out.println( angle1 + " " + angle2 );
		
		angle1 = normalise( angle1 );
		angle2 = normalise( angle2 );
		
		//System.out.println( angle1 + " " + angle2 );
		
		float diff = normalise( angle1 - angle2 );
		
		//System.out.println( diff );
		//System.out.println();
		
		return Math.abs( diff ) <= range;
	}
	
	private boolean inFieldOfView( Vector2d v ) {
		
		// TODO eeek atan! might need to find a better way to do this
		// TODO sensors wrong way round?
		float angle = (float)Math.atan2( v.y, v.x );
		
		//System.out.println( angle + " " + v );
		
		return angleWithin( angle, this.angle + vehicle.getAngle(), fieldOfView*0.5f );
	}
	
	private float distanceSqBorder( Vector2d pos, Vector2d borderPos ) {
		// this won't handle case when borders are at an angle of greater than 90 degrees
		// to the agents direction
		Vector2d diff = new Vector2d();
		diff = diff.subtract( borderPos, pos );
		float distSq = diff.dotProduct();
		if ( distSq < maxRange*maxRange ) {
			if ( inFieldOfView( diff ) )
				return distSq;
			
		}
		return Float.MAX_VALUE;
	}
	
	public void updateSensors( List nearbyObjects, int width, int height ) {
		Vector2d pos = new Vector2d();
		Vector2d diff = new Vector2d();
		Vector2d posBorder = new Vector2d();
		
		//pos = pos.setPolar( angle + vehicle.getAngle(), distance );
		pos = pos.set( vehicle.getPosition() );
		
		
		// TODO consider radius's
		
		VisibleObject nearest = null;
		float minDistSq = Float.MAX_VALUE;
		
		float distBorderTop    = distanceSqBorder( pos, posBorder.set( pos.x, 0 ) );
		float distBorderLeft   = distanceSqBorder( pos, posBorder.set( 0, pos.y ) );
		float distBorderBottom = distanceSqBorder( pos, posBorder.set( pos.x, height ) );
		float distBorderRight  = distanceSqBorder( pos, posBorder.set( width, pos.y ) );
		
		minDistSq = Math.min( 
			Math.min( distBorderTop, distBorderBottom ),
			Math.min( distBorderLeft, distBorderRight ) );
		
		int numObjects = nearbyObjects.size();
		for ( int i = 0; i < numObjects; i++ ) {
			VisibleObject object = (VisibleObject)nearbyObjects.get( i );
			Vector2d posi = object.getPosition();
			diff = diff.subtract( posi, pos );
			float distSq = diff.dotProduct();
			if ( distSq < minDistSq ) {
				if ( inFieldOfView( diff ) ) {
					nearest = object;
					minDistSq = distSq;
				}
			}
		}
		
		Color color = nearest != null? nearest.getColor() : null;
		distance = (float)Math.sqrt( minDistSq );
		//distance = distance - vehicle.getRadius();
		
		//if ( nearbyVehicles.size() != 0 )
		//	System.out.println( angle + ": " + dist );
		
		int numSensors = sensors.size();
		for ( int i = 0; i < numSensors; i++ ) {
			Sensor sensor = (Sensor)sensors.get( i );
			sensor.setColor( color );
			sensor.setDistance( distance );
		}
		
	}
	
	public void add( Sensor sensor ) {
		sensors.add( sensor );
		maxRange = Math.max( maxRange, sensor.getRange() );
	}
	
	public int getNumSensors() {
		return sensors.size();
	}
	
	public Sensor get( int i ) {
		return (Sensor)sensors.get( i );
	}
	
	
	
}
