/*
 * Created on Nov 30, 2003
 *
 */
package proj1.simulator;

/**
 * @author john
 * An alternative to java.awt.Color, so we don't trigger the loading of the awt toolkit
 * in console mode.
 */
public class Color {
	public static final Color white      = new Color( 255, 255, 255 );
	public static final Color lightGray  = new Color( 192, 192, 192 );
	public static final Color gray       = new Color( 128, 128, 128 );
	public static final Color darkGray   = new Color( 64, 64, 64 );
	public static final Color black      = new Color( 0, 0, 0 );
	public static final Color red    = new Color( 255, 0, 0 );
	public static final Color pink    = new Color( 255, 175, 175 );
	public static final Color orange    = new Color( 255, 200, 0 );
	public static final Color yellow = new Color( 255, 255, 0 );
	public static final Color green  = new Color( 0, 255, 0 );
	public static final Color magenta  = new Color( 255, 0, 255 );
	public static final Color cyan   = new Color( 0, 255, 255 );
	public static final Color blue   = new Color( 0, 0, 255 );
	
	
	private int rgb;
	
	public Color( int rgb ) {
		this.rgb = rgb;
	}
	
	public Color( int r, int g, int b ) {
		rgb = (r<<16) | (g << 8) | b;
	}
	
	public int getRGB() {
		return rgb;
	}
	
	public int getRed() {
		return (rgb >> 16) & 0xff;
	}
	
	public int getGreen() {
		return (rgb >> 8) & 0xff;
	}
		
	public int getBlue() {
		return rgb & 0xff;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		if ( obj instanceof Color )
			return ((Color)obj).rgb == rgb;
		return super.equals(obj);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return rgb;
	}

}
