/*
 * Created on Oct 25, 2003
 *
 */
package proj1.simulator;

import java.util.List;
import java.util.ArrayList;

import proj1.simulator.physics.Vector2d;

/**
 * A sort of crude quad tree
 * @author john
 *
 */
public final class CollisionTree {
	private int width, height;
	private int bucketWidth, bucketHeight;
	private Simulation sim;
	private Bucket[][] buckets = null;
	private int numBucketsX, numBucketsY;
	
	public CollisionTree( Simulation sim, int bucketWidth, int bucketHeight ) {
		this.sim = sim;
		this.width  = sim.getWidth();
		this.height = sim.getHeight();
		this.bucketWidth = bucketWidth;
		this.bucketHeight = bucketHeight;
		numBucketsX = width/bucketWidth;
		numBucketsY = height/bucketHeight;
		
		buckets = new Bucket[ numBucketsX ][ numBucketsY ];
		
		for ( int i = 0; i < numBucketsX; i++ ) {
			for ( int j = 0; j < numBucketsY; j++ ) {
				buckets[ i ][ j ] = new Bucket();
			}
		}
	}
	
	private Bucket getBucket( int i, int j ) {
		if ( i >=0 && j >= 0 && i < numBucketsX && j < numBucketsY )
			return buckets[ i ][ j ];
		return null;
	}
	
	private int clamp( int x, int xmin, int xmax ) {
		return x < xmin? xmin : (x>xmax? xmax : x);
	}
	
	private Bucket getBucketAt( int x, int y ) {
		int i = x/bucketWidth, j = y/bucketHeight;
		i = clamp( i, 0, numBucketsX-1 );
		j = clamp( j, 0, numBucketsY-1 );
		return getBucket( i, j );
	}
	
	public void add( List vehicles ) {
		int numVehicles = vehicles.size();
		for ( int i = 0; i < numVehicles; i++ ) {
			Vehicle veh = (Vehicle)vehicles.get( i );
			add( veh );
		}
	}
	
	private void add( Vehicle vehicle ) {
		// TODO check this works
		Vector2d pos = vehicle.getPosition();
		float range = Math.max( vehicle.getRadius(), vehicle.getMaxSensorRange() );
		
		int left = (int)(pos.x-range), right = (int)(pos.x+range),
			top  = (int)(pos.y-range), bottom = (int)(pos.y+range);
			
		left = left/bucketWidth;
		left = clamp( left, 0, numBucketsX-1 );
		right = right/bucketWidth;
		right = clamp( right, 0, numBucketsX-1 );
		
		top = top/bucketHeight;
		top = clamp( top, 0, numBucketsY-1 );
		bottom = bottom/bucketHeight;
		bottom = clamp( bottom, 0, numBucketsY-1 );
		
		for ( int i = left; i <= right; i++ ) {
			Bucket[] rowi = buckets[ i ];
			for ( int j = top; j <= bottom; j++ ) {
				rowi[ j ].add( vehicle );
			}
		}
		
		/*Bucket b1 = getBucketAt( left, top );
		Bucket b2 = getBucketAt( left, bottom );
		Bucket b3 = getBucketAt( right, top );
		Bucket b4 = getBucketAt( right, bottom );
		
		
		if ( b1 != b2 && b1 != b3 ) {
			b1.add( vehicle );
			b2.add( vehicle );
			b3.add( vehicle );
			b4.add( vehicle );
		}
		else if ( b1 != b2 ) {
			b1.add( vehicle );
			b2.add( vehicle );
		}
		else if ( b1 != b3 ) {
			b1.add( vehicle );
			b3.add( vehicle );
		}
		else {
			b1.add( vehicle );
		}*/
		
	}
	
	public void add( FixedObject obj ) {
		// TODO check this works
		Vector2d pos = obj.getPosition();
		float radius = obj.getRadius();
		
		int left = (int)(pos.x-radius), right = (int)(pos.x+radius),
			top  = (int)(pos.y-radius), bottom = (int)(pos.y+radius);
			
		Bucket b1 = getBucketAt( left, top );
		Bucket b2 = getBucketAt( left, bottom );
		Bucket b3 = getBucketAt( right, top );
		Bucket b4 = getBucketAt( right, bottom );
		
		
		if ( b1 != b2 && b1 != b3 ) {
			b1.add( obj );
			b2.add( obj );
			b3.add( obj );
			b4.add( obj );
		}
		else if ( b1 != b2 ) {
			b1.add( obj );
			b2.add( obj );
		}
		else if ( b1 != b3 ) {
			b1.add( obj );
			b3.add( obj );
		}
		else {
			b1.add( obj );
		}
		
	}
	
	public void remove( FixedObject obj ) {
		// TODO check this works
		Vector2d pos = obj.getPosition();
		float radius = obj.getRadius();
		
		int left = (int)(pos.x-radius), right = (int)(pos.x+radius),
			top  = (int)(pos.y-radius), bottom = (int)(pos.y+radius);
			
		Bucket b1 = getBucketAt( left, top );
		Bucket b2 = getBucketAt( left, bottom );
		Bucket b3 = getBucketAt( right, top );
		Bucket b4 = getBucketAt( right, bottom );
		
		
		if ( b1 != b2 && b1 != b3 ) {
			b1.remove( obj );
			b2.remove( obj );
			b3.remove( obj );
			b4.remove( obj );
		}
		else if ( b1 != b2 ) {
			b1.remove( obj );
			b2.remove( obj );
		}
		else if ( b1 != b3 ) {
			b1.remove( obj );
			b3.remove( obj );
		}
		else {
			b1.remove( obj );
		}
		
	}
	
	public void addFixed( List fixedObjects ) {
		int numObjects = fixedObjects.size();
		for ( int i = 0; i < numObjects; i++ ) {
			FixedObject obj = (FixedObject)fixedObjects.get( i );
			Vector2d pos = obj.getPosition();
			Bucket bucket = getBucketAt( (int)pos.x, (int)pos.y );
			bucket.add( obj ); 
		}
	}
	
	public void checkCollisionsAndSensors() {
		
		// TODO deal better with sensor range
		
		// check collisions (inter and intra bucket)
		for ( int i = 0; i < numBucketsX; i++ ) {
			for ( int j = 0; j < numBucketsY; j++ ) {
				Bucket bij   = getBucket( i,   j );
				bij.checkCollisionsAndSensors();
				/*Bucket bi1j  = getBucket( i+1, j   );
				Bucket bij1  = getBucket( i,   j+1 );
				Bucket bi1j1 = getBucket( i+1, j+1 );
				
				bij.checkCollisionsAndSensors();
				bij.checkCollisionsAndSensors( bi1j  );
				bij.checkCollisionsAndSensors( bij1  );
				bij.checkCollisionsAndSensors( bi1j1 );
				if ( bi1j != null )
					bi1j.checkCollisionsAndSensors( bij1 );*/
			}
		}
	
	}
	
	public void clear() {
		for ( int i = 0; i < numBucketsX; i++ ) {
			for ( int j = 0; j < numBucketsY; j++ ) {
				Bucket bij   = getBucket( i, j );
				bij.clear();
			}
		}
	}
	
	private class Bucket {
		private List vehicles = new ArrayList();
		private List fixedObjects = new ArrayList();
		
		public void clear() {
			vehicles.clear();
		}
		
		public void add( Vehicle veh ) {
			vehicles.add( veh );
		}
		
		public void add( FixedObject obj ) {
			fixedObjects.add( obj );
		}

		public void remove( FixedObject obj ) {
			fixedObjects.remove( obj );
		}
		
		public void checkCollisionsAndSensors() {
			sim.checkCollisionsAndSensors( vehicles, fixedObjects );
		}
		
	}

}
