/*
 * Created on Nov 20, 2003
 *
 */
package proj1.gui;

import javax.swing.*;

import proj1.Parameters;

import java.awt.*;
import java.awt.event.*;

/**
 * @author john
 *
 */
public class SpeciesDialog extends OkCancelDialog {
	private JTextField nameText    = null;
	private JTextField popSizeText = null;
	private JTextField mutationRateText = null;
	private JTextField recombinationRateText = null;
	private JTextField motorPowerText = null;
	private JTextField sensorRangeText = null;
	private SpeciesIcon speciesIcon = new SpeciesIcon();
	private JLabel speciesLabel = null;
	private Color[] colors = 
		{ Color.blue, Color.red, Color.yellow, Color.cyan, Color.magenta, Color.pink, Color.orange, new Color( 128, 0, 255 ) };
	private String[] colorNames = 
		{ "Blue", "Red", "Yellow", "Cyan", "Magenta", "Pink", "Orange", "Purple" };
	private JComboBox colorsCombo = null;
	
	private String[] sensorNames = { "No Sensors Groups", "One Sensor Group", "Two Sensor Groups", "Three Sensor Groups", "Four Sensor Groups", "Five Sensor Groups", "Six Sensor Groups", "Seven Sensor Groups", "Eight Sensor Groups" };
	private JComboBox numSensorsCombo  = null;
	
	private String[] sensorColorNames = { "No Color Sensors", "One Color Sensor", "Two Color Sensors", "Three Color Sensors", "Four Color Sensors" };
	private JComboBox numSensorColorsCombo  = null;
	
	private double[] sensorAngles = { Math.PI/2, Math.PI, 3*Math.PI/2, 2*Math.PI };
	private String[] sensorAngleNames = { "90 View", "180 View", "270 View", "360 View" };
	private JComboBox sensorAngleCombo = null;

	private JComboBox numHiddenNodesCombo = null;
	
	private String[] eatingHabits = { "Does Not Eat", "Herbivore", "Carnivore", "Omnivore" };
	private JComboBox eatingHabitsCombo = null;

	public SpeciesDialog( JFrame parent ) {
		super( parent, "Species" );
		init();
	}

	public SpeciesDialog( JDialog parent ) {
		super( parent, "Species" );
		init();
	}
	
	private void init() {
		JPanel centrePanel = new JPanel( new GridLayout( 2, 1, 10, 10 ) );
		
		nameText = new JTextField( "species" );
		popSizeText = new JTextField( "50");
		mutationRateText = new JTextField( "0.5" );
		recombinationRateText = new JTextField( "0.5" );
		motorPowerText = new JTextField( "10" );
		sensorRangeText = new JTextField( "32" );
		
		JPanel textPanel = new JPanel( new GridLayout( 6, 2, 10, 10 ) );
		
		textPanel.add( new JLabel( "Name" ) );
		textPanel.add( nameText );
		textPanel.add( new JLabel( "Population Size" ) );
		textPanel.add( popSizeText );
		textPanel.add( new JLabel( "Mutation Rate" ) );
		textPanel.add( mutationRateText );
		textPanel.add( new JLabel( "Recombination Rate" ) );
		textPanel.add( recombinationRateText );
		textPanel.add( new JLabel( "Motor Power" ) );
		textPanel.add( motorPowerText );
		textPanel.add( new JLabel( "Sensor Range" ) );
		textPanel.add( sensorRangeText );
		
		centrePanel.add( textPanel );
		
		JPanel speciesPanel = new JPanel( new GridLayout( 1, 2, 10, 10 ) );
		
		speciesLabel = new JLabel( speciesIcon );
		speciesPanel.add( speciesLabel );
		
		JPanel speciesControls = new JPanel( new GridLayout( 6, 1 ) );
		
		colorsCombo = new JComboBox( colorNames );
		colorsCombo.addItemListener( new ItemListener() {
			public void itemStateChanged( ItemEvent ie ) {
				JComboBox combo = (JComboBox)ie.getSource();
				if ( combo.getSelectedIndex() >= 0 ) {
					Color color = colors[ combo.getSelectedIndex() ];
					speciesIcon.setColor( color );
					speciesLabel.repaint();	
				}
			}
		} );
		
		numSensorsCombo = new JComboBox( sensorNames );
		numSensorsCombo.setSelectedIndex( speciesIcon.getNumSensorsGroups() );
		numSensorsCombo.addItemListener( new ItemListener() {
			public void itemStateChanged( ItemEvent ie ) {
				JComboBox combo = (JComboBox)ie.getSource();
				if ( combo.getSelectedIndex() >= 0 ) {
					speciesIcon.setNumSensorsGroups( combo.getSelectedIndex() );
					speciesLabel.repaint();	
				}
			}
		} );
		
		numSensorColorsCombo = new JComboBox( sensorColorNames );
		numSensorColorsCombo.setSelectedIndex( 1 );
		
		sensorAngleCombo = new JComboBox( sensorAngleNames );
		sensorAngleCombo.setSelectedIndex( 1 );
		sensorAngleCombo.addItemListener( new ItemListener() {
			public void itemStateChanged( ItemEvent ie ) {
				JComboBox combo = (JComboBox)ie.getSource();
				if ( combo.getSelectedIndex() >= 0 ) {
					speciesIcon.setSensorAngle( sensorAngles[ combo.getSelectedIndex() ] );
					speciesLabel.repaint();	
				}
			}
		} );
		
		String[] hiddenNames = new String[ 17 ];
		for ( int i = 0; i < hiddenNames.length; i++ ) {
			if ( i == 0 ) {
				hiddenNames[ i ] = "No Hidden Nodes";
			}
			else if ( i == 1 ) {
				hiddenNames[ i ] = "1 Hidden Node";
			}
			else {
				hiddenNames[ i ] = i + " Hidden Nodes";
			}
		}
		
		
		numHiddenNodesCombo = new JComboBox( hiddenNames );
		
		eatingHabitsCombo = new JComboBox( eatingHabits );
		eatingHabitsCombo.setSelectedIndex( 1 );
		
		speciesControls.add( colorsCombo );
		speciesControls.add( numSensorsCombo );
		speciesControls.add( numSensorColorsCombo );
		speciesControls.add( sensorAngleCombo );
		speciesControls.add( numHiddenNodesCombo );
		speciesControls.add( eatingHabitsCombo );

		speciesPanel.add( speciesControls );
		
		centrePanel.add( speciesPanel );
		
		getContentPane().add( centrePanel, BorderLayout.CENTER );
	}
	
	private void setWidgets( Parameters species ) {
		nameText.setText( species.getParameter( "name", "species" ) );
		popSizeText.setText( String.valueOf( species.getParameter( "populationSize", 50 ) ) );
		mutationRateText.setText( String.valueOf( species.getParameter( "mutationRate", 0.5 ) ) );
		recombinationRateText.setText( String.valueOf( species.getParameter( "recombinationRate", 0.5 ) ) );
		motorPowerText.setText( String.valueOf( species.getParameter( "motorPower", 10.0 ) ) );
		sensorRangeText.setText( String.valueOf( species.getParameter( "sensorRange", 32.0 ) ) );
		Color color = new Color( species.getParameter( "color", 0xFF ) );
		speciesIcon.setColor( color );
		for ( int i = 0; i < colors.length; i++ ) {
			if ( colors[ i ].equals( color ) )
				colorsCombo.setSelectedIndex( i );
		}
		speciesIcon.setNumSensorsGroups( species.getParameter( "numSensorGroups", 2 ) );
		numSensorsCombo.setSelectedIndex( speciesIcon.getNumSensorsGroups() );
		numSensorColorsCombo.setSelectedIndex( species.getParameter( "numSensorColors", 1 ) );
		
		double angle = species.getParameter( "sensorAngle", Math.PI );
		speciesIcon.setSensorAngle( angle );
		for ( int i = 0; i < sensorAngles.length; i++ ) {
			if ( sensorAngles[ i ] == angle )
				sensorAngleCombo.setSelectedIndex( i );
		}
		
		int numHidden = species.getParameter( "numHiddenNodes", 0 );
		numHiddenNodesCombo.setSelectedIndex( numHidden );
		
		boolean carnivore = species.getParameter( "carnivore", false );
		boolean herbivore = species.getParameter( "herbivore", true );
		
		if ( !carnivore && !herbivore )
			eatingHabitsCombo.setSelectedIndex( 0 );
		else if ( !carnivore && herbivore )
			eatingHabitsCombo.setSelectedIndex( 1 );
		else if ( carnivore && !herbivore )
			eatingHabitsCombo.setSelectedIndex( 2 );
		else
			eatingHabitsCombo.setSelectedIndex( 3 );
	}
	
	private void setParameters( Parameters species ) {
		species.setParameter( "name", nameText.getText() );
		species.setParameter( "populationSize", extractInt( popSizeText.getText() ) );
		species.setParameter( "mutationRate", extractDouble( mutationRateText.getText() ) );
		species.setParameter( "recombinationRate", extractDouble( recombinationRateText.getText() ) );
		species.getParameter( "motorPower", extractDouble( motorPowerText.getText() ) );
		species.getParameter( "sensorRange", extractDouble( sensorRangeText.getText() ) );
		species.setParameter( "color", speciesIcon.getColor().getRGB() );
		species.setParameter( "numSensorGroups", speciesIcon.getNumSensorsGroups() );
		species.setParameter( "numSensorColors", numSensorColorsCombo.getSelectedIndex() );
		species.setParameter( "sensorAngle", speciesIcon.getSensorAngle() );
		species.setParameter( "numHiddenNodes", numHiddenNodesCombo.getSelectedIndex() );
		
		boolean carnivore = false;
		boolean herbivore = false;
		
		switch( eatingHabitsCombo.getSelectedIndex() ) {
			case 0: carnivore = herbivore = false;
			break;
			case 1: carnivore = false; herbivore = true;
			break;
			case 2: carnivore = true; herbivore = false;
			break;
			case 3: carnivore = true; herbivore = true;
			break;
		}
		
		species.setParameter( "carnivore", carnivore );
		species.setParameter( "herbivore", herbivore );
	}
	
	protected boolean validateInput() {
		return validateInteger( popSizeText )
		&&     validateDouble( mutationRateText )
		&&     validateDouble( recombinationRateText )
		&&     validateDouble( motorPowerText )
		&&     validateDouble( sensorRangeText );
	}
	
	public void editSpecies( Parameters species ) {
		setWidgets( species );
		if ( showOkCancel() ) {
			setParameters( species );
		}
	}
	
	public Parameters createNewSpecies() {
		if ( showOkCancel() ) {
			Parameters species = new Parameters();
			setParameters( species );
			return species;
		}
		return null;
	}

}
