/*
 * SimulationDialog.java
 *
 * Created on 07 November 2003, 12:06
 */

package proj1.gui;

import proj1.*;
import proj1.simulator.*;
import java.awt.*;
import java.util.ArrayList;

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/**
 *
 * @author  msc37jxm
 */
public class SimulationDialog extends OkCancelDialog {
	private JTextField birthRateText = null;
	private JTextField foodLevelText = null;
	private JTextField penaltyText = null;
	private JTextField rewardText = null;
	private JTextField rocksText = null;
	private JTextField widthText = null;
	private JTextField heightText = null;
	private JTextField dataDirectoryText = null;
	
	private JList speciesList = new JList();
	private ArrayList species = new ArrayList();
	
	private JButton editButton = null;
	private JButton removeButton = null;
	
	/** Creates a new instance of SimulationDialog */
	public SimulationDialog( JFrame parent ) {
		super( parent, "New Simulation" );
		
		birthRateText = new JTextField( " 100" );
		foodLevelText = new JTextField( " 100" );
		penaltyText   = new JTextField( " 0.2" );
		rewardText    = new JTextField( "20.0" );
		rocksText     = new JTextField( " 100" );
		widthText     = new JTextField( "1500" );
		heightText    = new JTextField( "1500" );
		dataDirectoryText = new JTextField( new java.io.File( System.getProperty( "user.dir" ), "data" ).toString() );
		
		GridBagLayout gridBag = new GridBagLayout();
		GridBagConstraints c = new GridBagConstraints();
		
		JPanel centrePanel = new JPanel( gridBag );
		
		JPanel textPanel = new JPanel( new GridLayout( 4, 4, 10, 10 ) );
		
		addTextField( textPanel, "Width", widthText );
		addTextField( textPanel, "Height", heightText );
		addTextField( textPanel, "Birth Rate", birthRateText );
		addTextField( textPanel, "Food Level", foodLevelText );
		addTextField( textPanel, "Penalty", penaltyText );
		addTextField( textPanel, "Reward", rewardText );
		addTextField( textPanel, "Number of Rocks", rocksText );
		
		
		c.gridwidth = GridBagConstraints.REMAINDER;
		gridBag.setConstraints( textPanel, c );
		centrePanel.add( textPanel );
		
		JPanel speciesPanel = new JPanel( new GridLayout( 1, 2, 10, 10) );
		Border border = BorderFactory.createTitledBorder( "Species" );
		speciesPanel.setBorder( border );

		speciesList.addListSelectionListener( new ListSelectionListener() {
			public void valueChanged( ListSelectionEvent lse ) {
				int index = speciesList.getSelectedIndex();
				boolean enabled = ( index >= 0 && index < species.size() );
				editButton.setEnabled( enabled );
				removeButton.setEnabled( enabled );
			}
		} );
		speciesPanel.add( speciesList );
		
		JPanel speciesButtonPanel = new JPanel( new GridLayout( 3, 1, 5, 5 ) );
		
		JButton addButton = new JButton( "Add" );
		addButton.addActionListener( new ActionAdapter(this, "addSpecies"));
		editButton = new JButton( "Edit" );
		editButton.addActionListener( new ActionAdapter(this, "editSpecies"));
		editButton.setEnabled( false );
		
		removeButton = new JButton( "Remove" ); 
		removeButton.addActionListener( new ActionAdapter(this, "removeSpecies"));
		removeButton.setEnabled( false );
		
		speciesButtonPanel.add( addButton );
		speciesButtonPanel.add( editButton );
		speciesButtonPanel.add( removeButton );
		
		speciesPanel.add( speciesButtonPanel );
		
		gridBag.setConstraints( speciesPanel, c );
		centrePanel.add( speciesPanel );
		
		JPanel dataPanel = new JPanel();
		
		dataPanel.add( new JLabel( "Data Directory" ) );
		
		JButton browseButton = new JButton( "..." );
		browseButton.addActionListener( new ActionAdapter(this, "browseDataDir"));
		dataPanel.add( dataDirectoryText );
		dataPanel.add( browseButton );
		
		gridBag.setConstraints( dataPanel, c );
		centrePanel.add( dataPanel );
		
		getContentPane().add( centrePanel, BorderLayout.CENTER );
		
	}
	
	private void addTextField( JPanel panel, String labelText, JTextField textField ) {
		JLabel label = new JLabel( labelText );
		panel.add( label );
		panel.add( textField );
	}
	
	private String[] speciesNames() {
		String[] names = new String[ species.size() ];
		for ( int i = 0; i < names.length; i++ ) {
			names[ i ] = ((Parameters)species.get( i )).getParameter( "name", "species" );
		}
		return names;
	}
	
	private void addSpecies() {
		SpeciesDialog speciesDialog = new SpeciesDialog( this );
		Parameters params = speciesDialog.createNewSpecies();
		if ( params != null ) {
			species.add( params );
			speciesList.setListData( speciesNames() );
		}
	}
	
	private void editSpecies() {
		
		int index = speciesList.getSelectedIndex();
		if ( index >= 0 && index < species.size() ) {
			Parameters params = (Parameters)species.get( index );
			SpeciesDialog speciesDialog = new SpeciesDialog( this );
			speciesDialog.editSpecies( params );
			speciesList.setListData( speciesNames() );
		}
	}
	
	private void removeSpecies() {
		int index = speciesList.getSelectedIndex();
		if ( index >= 0 && index < species.size() ) {
			species.remove( index );
			speciesList.setListData( speciesNames() );
		}
	}
	
	public Environment createNewSimulation() {
		
		if ( showOkCancel() ) {
			
			int birthRate = extractInt( birthRateText.getText() );
			int foodLevel = extractInt( foodLevelText.getText() );
			int rocks   = extractInt( rocksText.getText() );
			int width   = extractInt( widthText.getText() );
			int height  = extractInt( heightText.getText() );
			double penalty = extractDouble( penaltyText.getText() );
			double reward = extractDouble( rewardText.getText() );
			
			if ( width > 0 && height > 0 ) {
				Parameters params = new Parameters();
				
				params.setParameter( "birthRate", birthRate );
				params.setParameter( "foodLevel", foodLevel );
				params.setParameter( "penalty", penalty );
				params.setParameter( "reward", reward );
				params.setParameter( "rocks", rocks );
				params.setParameter( "width", width );
				params.setParameter( "height", height );
				
				params.setParameter( "dataDirectory", dataDirectoryText.getText().trim() );
				
				Parameters[] speciesParams = new Parameters[ species.size() ];
				speciesParams = (Parameters[])species.toArray( speciesParams );
				Environment environment = new Environment( params, speciesParams );
				
				
				return environment;
			}
		}
		return null;
	}
	
	protected void browseDataDir() {
		JFileChooser dirChooser = new JFileChooser();
		dirChooser.setFileSelectionMode( JFileChooser.DIRECTORIES_ONLY );
		dirChooser.setDialogTitle( "Choose Data Directory" );
		if ( dirChooser.showSaveDialog(this) == JFileChooser.APPROVE_OPTION ) {
			 dataDirectoryText.setText( dirChooser.getSelectedFile().toString() );
		}
	}
	
	
	protected boolean validateInput() {
		return species.size() > 0
		    && validateInteger( foodLevelText )
		    && validateInteger( rocksText )
		    && validateInteger( widthText )
		    && validateInteger( widthText )
		    && validateDouble( rewardText )
			&& validateDouble( penaltyText );
	}
	
}
