/*
 * Created on Nov 6, 2003
 *
 */
package proj1.gui;

import proj1.simulator.*;
import proj1.simulator.physics.Vector2d;

import javax.swing.JPanel;
import java.awt.*;
import java.util.HashMap;


/**
 * @author john
 *
 */
public class SimPanel extends JPanel {
	private Simulation sim = null;
	private float scale = 1.0f; 
	private int zoomLevel = 8;
	private HashMap colorMap = new HashMap();
	
	public void setSimulation( Simulation sim ) {
		this.sim = sim;
		zoomLevel = 8;
		setZoom( zoomLevel );
	}
	
	public void zoomIn() {
		zoomLevel++;
		setZoom( zoomLevel );
	}
	
	public void zoomOut() {
		zoomLevel = Math.max( 1, zoomLevel-1 );
		setZoom( zoomLevel );
	}
	
	private void setZoom( int zoomLevel ) {
		setScale( zoomLevel/8.0f );
	}
	
	public float getScale() {
		return scale;
	}
	
	private void setScale( float scale ) {
		this.scale = scale;
		if ( sim != null ) {
			setSize( (int)(scale*sim.getWidth()), (int)(scale*sim.getHeight()) );
			invalidate();
			getParent().validate();	
		}
		repaint();
	}

	public Dimension getPreferredSize() {
		if ( sim != null ) {
			return new Dimension( (int)(scale*sim.getWidth()), (int)(scale*sim.getHeight()) );
		}
		return new Dimension( 512, 512 );
	}
	
	private java.awt.Color getAWTColor( proj1.simulator.Color color ) {
		java.awt.Color awtcolor = (java.awt.Color)colorMap.get( color );
		if ( awtcolor == null ) {
			awtcolor = new java.awt.Color( color.getRGB() );
			colorMap.put( color, awtcolor );
		}	
		return awtcolor;
	}
	
	public void paint( Graphics g ) {
		
		g.setColor( java.awt.Color.WHITE );
		Dimension size = getSize();
		g.fillRect( 0, 0, size.width, size.height );
		
		if ( sim == null )
			return;
		Vector2d v = new Vector2d();
		
		for ( int i = 0; i < sim.getNumFixedObjects(); i++ ) {
			FixedObject obj = sim.getFixedObject( i );
			Vector2d pos = obj.getPosition();
			float radius = obj.getRadius();
    
			int x = (int)(scale*(pos.x-radius));
			int y = (int)(scale*(pos.y-radius));
			int w = (int)(scale*2*radius);
			int h = (int)(scale*2*radius);
    
			g.setColor( getAWTColor( obj.getColor() ) );
			g.fillOval( x, y, w, h );
		}
		
		for ( int i = 0; i < sim.getNumVehicles(); i++ ) {
			Vehicle veh = sim.getVehicle( i );
			Vector2d pos = veh.getPosition();
			float radius = veh.getRadius();
			float angle  = veh.getAngle();
    
			if ( scale >= 1.0f ) {
				g.setColor( java.awt.Color.black );
				Vehicle.Motor[] motors = { veh.getMotor( 0 ), veh.getMotor( 1 ) };
				for ( int j = 0; j < motors.length; j++ ) {
					Vehicle.Motor motor = motors[ j ];
					v = motor.getPosition( v );
					int mx = (int)(scale*v.x);
					int my = (int)(scale*v.y);
					int r = (int)(scale*radius/2);
					g.fillOval( mx-r, my-r, 2*r, 2*r );
				}
			}
    
    
			int x = (int)(scale*(pos.x-radius));
			int y = (int)(scale*(pos.y-radius));
			int w = (int)(scale*2*radius);
			int h = (int)(scale*2*radius);
    
			g.setColor( getAWTColor( veh.getColor() ) );
			g.fillOval( x, y, w, h );
    
    		if ( scale >= 1.0f ) {
    			
				g.setColor( java.awt.Color.black );
				g.drawOval( x, y, w, h );
    
				/*int x1 = (int)(scale*pos.x), 
					y1 = (int)(scale*pos.y),
					x2 = (int)(scale*(pos.x + radius*Math.cos( angle ))),
					y2 = (int)(scale*(pos.y + radius*Math.sin( angle )));
	    
	    		g.drawLine( x1, y1, x2, y2 );*/
	    		SensorGroup[] sensorGroups = veh.getSensorGroups();
	    		for ( int j = 0; j < sensorGroups.length; j++ ) {
					SensorGroup sensorGroup = sensorGroups[ j ];
					float sensorAngle = angle + sensorGroup.getAngle();
					float fov = sensorGroup.getFieldOfView();
					x = (int)(scale*pos.x);
					y = (int)(scale*pos.y);
					drawAngle( g, x, y, sensorAngle - 0.5*fov, radius*scale );
					drawAngle( g, x, y, sensorAngle + 0.5*fov, radius*scale );
	    		}
    		}
		}
		
		int width  = (int)(scale*sim.getWidth());
		int height = (int)(scale*sim.getHeight());
		
		g.setColor( java.awt.Color.black );
		g.drawRect( 0, 0, width-1, height-1 );
		
	}
	
	private void drawAngle( Graphics g, int x, int y, double angle, float radius ) {
		g.drawLine( x, y, (int)(x + radius*Math.cos( angle )), (int)(y + radius*Math.sin( angle )));
	}

}
