/*
 * Created on Nov 6, 2003
 *
 */
package proj1.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;


/**
 * @author john
 *
 */
public class ActionAdapter implements ActionListener {
	private Class clazz = null;
	private Object object = null;
	private String methodName = null;
	
	public ActionAdapter( Object object, String methodName ) {
		this( object.getClass(), object, methodName );
	}
	
	public ActionAdapter( Class clazz, Object object, String methodName ) {
		this.clazz = clazz;
		this.object = object;
		this.methodName = methodName;
	}

	private Method findMethod( String methodName, Class clazz ) {
		try {
			return clazz.getDeclaredMethod( methodName, new Class[ 0 ] );
		}
		catch( Exception e ) {
		}
		return findMethod( methodName, clazz.getSuperclass() );
	}

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent ae) {
		try {
			Method method = findMethod( methodName, clazz );
			method.setAccessible( true );
			method.invoke( object, new Object[ 0 ] );
		}
		catch( Exception e ) {
			e.printStackTrace();
		}
	}

}
