/*
 * Created on Nov 12, 2003
 *
 */
package proj1;

import proj1.nnet.NeuralNet;
import proj1.nnet.Neuron;
import proj1.simulator.Brain;
import proj1.simulator.Effector;
import proj1.simulator.Sensor;

/**
 * @author john
 *
 */
public class NeuralNetBrain implements Brain {
	private NeuralNet nnet = new NeuralNet();
	
	public NeuralNetBrain( NeuralNetGenotype nngenotype ) {
		nngenotype.initNeuralNet( nnet );
	}

	/* (non-Javadoc)
	 * @see proj1.simulator.Brain#receiveInputs(proj1.simulator.Sensor[])
	 */
	public void receiveInputs(Sensor[] sensors) {
		nnet.reset();
		for ( int i = 0; i < sensors.length; i++ )
			nnet.getInput( i+1 ).addInput( sensors[ i ].getValue() );
			
		nnet.getInput( 0 ).addInput( 1.0f );
			
		nnet.update();
	}

	/* (non-Javadoc)
	 * @see proj1.simulator.Brain#computeOutputs(proj1.simulator.Effector[])
	 */
	public void computeOutputs(Effector[] effectors) {
		nnet.update();
		for ( int i = 0; i < effectors.length; i++ )
			effectors[ i ].setOutput( nnet.getOutput( i ).getOutput() /*+ 0.5f*/ );
	}

}
