/*
 * Created on Nov 25, 2003
 *
 */
package proj1;

import proj1.simulator.Color;
import java.io.*;
import java.lang.reflect.Array;

/**
 * @author john
 *
 */
public class DataEncoder {
	private Writer writer = null;
	
	public DataEncoder( Writer writer ) {
		this.writer = writer;
	}
	
	public void encode( String name, Object data ) throws IOException {
		writer.write( name );
		writer.write( '=' );
		writeData( data );
		writer.write( '\n' );
	}
	
	public void space() throws IOException {
		writer.write( '\n' );
	}
	
	private String escapedString( String str ) {
		// TODO escapedString
		return str;
	}
	
	private void writeData( Object data ) throws IOException {
		if ( data instanceof Number  || data instanceof Boolean )
			writer.write( data.toString() );
		else if ( data instanceof String ) {
			writer.write( '\"' );
			writer.write( escapedString( data.toString() ) );
			writer.write( '\"' );
		}
		else if ( data instanceof Color ) {
			Color color = (Color)data;
			writer.write( "RGB(" );
			writer.write( String.valueOf( color.getRed() ) );
			writer.write( ',' );
			writer.write( String.valueOf( color.getGreen() ) );
			writer.write( ',' );
			writer.write( String.valueOf( color.getBlue() ) );
			writer.write( ')' );
		}
		else if ( data.getClass().isArray() ) {
			writer.write( '{' );
			int length = Array.getLength( data );
			for ( int i = 0; i < length; i++ ) {
				if ( i != 0 )
					writer.write( ',' );
				writeData( Array.get( data, i ) );
			}
			writer.write( '}' );
		}
		else {
			throw new RuntimeException( "Cannot store data" + data );
		}
	}
	
	public void close() throws IOException {
		writer.flush();
		writer.close();
	}

}
