/*
 * Agent.java
 *
 * Created on 11 November 2003, 13:08
 */

package proj1;


import proj1.simulator.*;
import proj1.evol.*;

/**
 *
 * @author  msc37jxm
 */
public class Agent extends Vehicle implements Phenotype {
	private static int MAX_AGE = 10000;
	private int age = 1;
	private float metabolicRate = 0.1f;
	private float nextEnergy = 0.0f;
	private float energy = 1.0f;
	private float fitness = 0.0f;
	private AgentGenotype genotype = null;
	private boolean carnivore = false;
	private boolean herbivore = true;
	
	/** Creates a new instance of Agent */
	public Agent( AgentGenotype genotype, boolean carnivore, boolean herbivore ) {
		super( new NeuralNetBrain( genotype.getNeuralNetGenotype() ),
								   genotype.getNumSensorGroups(),
								   genotype.getSensorAngle(),
								   genotype.getSensorColors(),
								   genotype.getSensorSensitivities(),
								   genotype.getSensorRange(),
								   genotype.getMotorPower(),
								   genotype.getMotorAngle() );
		setAngle( (float)(2*Math.PI*Math.random()) );
		this.genotype = genotype;
		this.carnivore = carnivore;
		this.herbivore = herbivore;
	}
	
	public boolean isCarnivore() {
		return carnivore;
	}
	
	public boolean isHerbivore() {
		return herbivore;
	}
	
	public void changeEnergy( float energyChange ) {
		energy += energyChange;
	}
	
	public float getEnergy() {
		return energy;
	}
	
	public float getFitness() {
		// TODO figure out a better fitness value
		//return energy/(int)(Math.ceil( age/25.0 ));
		return fitness;
	}
	
	public Genotype getGenotype() {
		return genotype;
	}
	
	public Phenotype make( Genotype genotype ) {
		Agent agent = new Agent( (AgentGenotype)genotype, carnivore, herbivore );
		agent.setColor( getColor() );
		return agent;
	}
	
	/* (non-Javadoc)
	 * @see proj1.simulator.Vehicle#integrate(float)
	 */
	public void integrate(float dt) {
		super.integrate(dt);
		
		if ( energy > 0 ) {
			// energy dissipated a bit like friction
			// resulting in a maximum effective value
			nextEnergy = energy -dt*metabolicRate*energy;
		}
		
	}

	
	/* (non-Javadoc)
	 * @see proj1.simulator.Vehicle#update()
	 */
	public void update() {
		super.update();
		energy = nextEnergy;
		fitness = (energy >= 1)? 1 : -1;
		age++;
	}

	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object o) {
		Phenotype p = (Phenotype)o;
		float fitness1 = getFitness();
		float fitness2 = p.getFitness();
		if ( fitness1 < fitness2 ) return -1;
		if ( fitness1 > fitness2 ) return +1;
		return 0;
	}

	/* (non-Javadoc)
	 * @see proj1.evol.Phenotype#getAge()
	 */
	public int getAge() {
		return age;
	}

	
}
