/*
 * Created on Oct 19, 2003
 *
 */
package proj1.simulator.physics;

/**
 * @author john
 *
 */
public final class Vector2d {
	public float x, y;
	
	/** Make a vector with x,y = 0, 0. **/
	public Vector2d() {
		this( 0, 0 );
	}
	
	/** Make a vector x,y. **/
	public Vector2d( float x, float y ) {
		set( x, y );
	}
	
	public Vector2d zero() {
		return set( 0, 0 );
	}
	
	/** Set this vector to x,y then return the vector. **/
	public Vector2d set( float x, float y ) {
		this.x = x;
		this.y = y;
		return this;
	}
	
	/** Set this vector to v.x,v.y then return the vector. **/
	public Vector2d set( Vector2d v ) {
		return set( v.x, v. y );
	}
	
	/** Set the vector using polar coordinates. **/
	public Vector2d setPolar( float angle, float length ) {
		x = length*(float)Math.cos( angle );
		y = length*(float)Math.sin( angle );
		return this;
	}
	
	/** Add s to x,y then return this vector. **/
	public Vector2d add( float s ) {
		x = x+s;
		y = y+s;
		return this;
	}
	
	/** Add x,y and return this vector. **/
	public Vector2d add( float x, float y ) {
		this.x = this.x+x;
		this.y = this.y+y;
		return this;	
	}
	
	/** Add v and return this vector. **/
	public Vector2d add( Vector2d v ) {
		return add( v.x, v.y );
	}
	
	/** Set this vector to u+v and return it. **/
	public Vector2d add( Vector2d u, Vector2d v ) {
		return set( u ).add( v );
	}
	
	/** Subtract s from both x and y and return this vector. **/
	public Vector2d subtract( float s ) {
		x = x-s;
		y = y-s;
		return this;
	}
	
	/** Subtract x,y and return this vector. **/
	public Vector2d subtract( float x, float y ) {
		this.x = this.x-x;
		this.y = this.y-y;
		return this;	
	}
	
	/** Subtract v and return this vector. **/
	public Vector2d subtract( Vector2d v ) {
		return subtract( v.x, v.y );
	}
	
	/** Set this vector to u-v and return it. **/
	public Vector2d subtract( Vector2d u, Vector2d v ) {
		return set( u ).subtract( v );
	}
	
	/** Mutliply by s and return this vector. **/
	public Vector2d multiply( float s ) {
		x = x*s;
		y = y*s;
		return this;
	}
	
	/** Mutliply v by s set this vector. return this vector. **/
	public Vector2d multiply( float s, Vector2d v ) {
		return set( v ).multiply( s );
	}
	
	/** Multipy by v (component-wise) and return this. **/
	public Vector2d multiply( Vector2d v ) {
		x = x*v.x;
		y = y*v.y;
		return this;
	}
	
	/** Set this vector to u*v and return it. **/
	public Vector2d multiply( Vector2d u, Vector2d v ) {
		return set( u ).multiply( v );
	}
	
	/** Divide by s and return this. **/
	public Vector2d divide( float s ) {
		x = x/s;
		y = y/s;
		return this;
	}
	
	/** Divide v by s and return this. **/
	public Vector2d divide( Vector2d v, float s ) {
		return set( v ).divide( s );
	}
	
	/** Divide by v (component-wise) and return this. **/
	public Vector2d divide( Vector2d v ) {
		x = x/v.x;
		y = y/v.y;
		return this;
	}
	
	/** Set this vector to u/v and return it. **/
	public Vector2d divide( Vector2d u, Vector2d v ) {
		return set( u ).divide( v );
	}
	
	/** Caculate the "dot product" of this vector and v. **/
	public float dotProduct( Vector2d v ) {
		return x*v.x + y*v.y;
	}
	
	/** Caculate the "dot product" of this vector and x,y. **/
	public float dotProduct( float x, float y ) {
		return this.x*x + this.y*y;
	}
	
	/** Returns the distance between this vector and v. **/
	public float distance( Vector2d v ) {
		float dx = x-v.x, dy = y-v.y;
		return (float)Math.sqrt( dx*dx + dy*dy );
	}
	
	public float distanceSq( Vector2d v ) {
		float dx = x-v.x, dy = y-v.y;
		return dx*dx + dy*dy;
	}
	
	/** Is v with radius of this vector? **/
	public boolean inRadius( Vector2d v, float radius ) {
		float dx = x-v.x, dy = y-v.y;
		return dx*dx + dy*dy <= radius*radius;
	}
	
	/** Calculate the "dot product" of this vector with itself. **/
	public float dotProduct() {
		return dotProduct( this );
	}


	/** Calculate the length (magnitude) of this vector. **/
	public float magnitude() {
		return (float)Math.sqrt( dotProduct() );
	}
	
	/** Normalise this vector, so that it is of unit length. **/
	public Vector2d normalise() {
		return divide( magnitude() );
	}
	
	public String toString() {
		return "x="+x+",y="+y;
	}

}
