/*
 * Created on Oct 29, 2003
 *
 */
package proj1.simulator;

/**
 * @author john
 *
 */
public class LightSensor implements Sensor {
	private float value;
	private float range = 32;
	private float sensitivity = 0.0f;

	public LightSensor( float range ) {
		this.range = range;
	}

	/* (non-Javadoc)
	 * @see proj1.simulator.Sensor#getValue()
	 */
	public float getValue() {
		return value;
	}

	/* (non-Javadoc)
	 * @see proj1.simulator.Sensor#setDistance(float)
	 */
	public void setDistance(float distance) {
		if ( distance > range )
			value = 0.0f;
		else {
			distance = Math.min( range, distance );
			
			distance = distance/range; // normalise
			
			distance = Math.max( 0.0f, distance-sensitivity );
			
			value = 1.0f - (distance*distance);
		}
	}

	/* (non-Javadoc)
	 * @see proj1.simulator.Sensor#setColor(java.awt.Color)
	 */
	public void setColor(Color color) {
		
	}

	/* (non-Javadoc)
	 * @see proj1.simulator.Sensor#getRange()
	 */
	public float getRange() {
		return range;
	}

	/* (non-Javadoc)
	 * @see proj1.simulator.Sensor#setSensitivity(float)
	 */
	public void setSensitivity(float sensitivity) {
		
	}

}
