/*
 * Created on Nov 12, 2003
 *
 */
package proj1.simulator;


/**
 * @author john
 *
 */
public class ColorSensor implements Sensor {
	private Color triggerColor = null;
	private Color color = null;
	private float value;
	private float range = 32;
	private float bits = 24.0f;
	private float sensitivity = 0.0f;
	
	public ColorSensor( Color color, float range ) {
		this.triggerColor = color;
		this.range = range;
	}

	private int numBits( int bits ) {
		int n = 0;
		for ( int i = 0; i < 24; i++ ) {
			if ( (bits & 1) != 0 ) n++;
			bits = bits >> 1;
		}
		return n;
	}
	
	private float similarity( int rgb1, int rgb2 ) {
		// return a value between 0 and 1, representign portion of bits that match
		int common = 0x00FFFFFF & (~(rgb1 ^ rgb2));
		return numBits( common )/bits;
	}

	private float similarity( Color col1, Color col2 ) {
		int dr = col1.getRed()   - col2.getRed(),
		    dg = col1.getGreen() - col2.getGreen(),
		    db = col1.getBlue()  - col2.getBlue();
		    
		float dSq = dr*dr + dg*dg + db*db;
		return (float)(1.0 - dSq/(3*255*255));
	}

	/* (non-Javadoc)
	 * @see proj1.simulator.Sensor#getValue()
	 */
	public float getValue() {
		if ( color == null ) return 0.0f;
		//float similarity = similarity( triggerColor.getRGB(), color.getRGB() );
		//System.out.println( color + " " + similarity  + " " + Integer.toBinaryString(triggerColor.getRGB() ^ color.getRGB()) );
		//return color.equals( triggerColor ) ? value : 0.0f;
		//return similarity( triggerColor.getRGB(), color.getRGB() );
		return similarity( triggerColor, color ) * value;
		//return color.equals( triggerColor ) ? 1.0f : -1.0f;
	}

	/* (non-Javadoc)
	 * @see proj1.simulator.Sensor#setDistance(float)
	 */
	public void setDistance(float distance) {
		if ( distance > range )
			value = 0.0f;
		else {
			distance = Math.min( range, distance );
			
			distance = distance/range; // normalise
			
			distance = Math.max( 0.0f, distance-sensitivity );
			
			value = 1.0f - (distance*distance);
		}
	}

	/* (non-Javadoc)
	 * @see proj1.simulator.Sensor#setColor(java.awt.Color)
	 */
	public void setColor(Color color) {
		this.color = color;
	}

	/* (non-Javadoc)
	 * @see proj1.simulator.Sensor#getRange()
	 */
	public float getRange() {
		return range;
	}

	/* (non-Javadoc)
	 * @see proj1.simulator.Sensor#setSensitivity(float)
	 */
	public void setSensitivity(float sensitivity) {
		this.sensitivity = sensitivity;
	}

}
