/*
 * Created on Dec 3, 2003
 *
 */
package proj1.simulator;

import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;

/**
 * @author john
 *
 */
public class CollisionController{
	private Simulation sim = null;
	private CollisionHandler handler = null;
	private HashMap collisionMap = new HashMap();
	private List collisionList = new ArrayList();
	
	public CollisionController( Simulation sim, CollisionHandler handler ) {
		this.handler = handler;
		this.sim = sim;
	}
	
	public int getNumCollisions() {
		return collisionList.size();
	}
	
	public void reset() {
		collisionMap.clear();
		collisionList.clear();
	}
	
	public void doCollisions() {
		int numCollisions = collisionList.size();
		for ( int i = 0; i < numCollisions; i++ )
			((Collision)collisionList.get( i )).doCollision();
		reset();
	}
	
	public void vehicleCollision( Vehicle veh1, Vehicle veh2 ) {
		VehicleCollision collision = new VehicleCollision( veh1, veh2 );
		if ( !collisionMap.containsKey( collision ) ) {
			collisionMap.put( collision, collision );
			collisionList.add( collision );
		}
	}
	
	public void fixedObjectCollision( Vehicle veh, FixedObject fixedObject ) {
		FixedObjectCollision collision = new FixedObjectCollision( veh, fixedObject );
		if ( !collisionMap.containsKey( collision ) ) {
			collisionMap.put( collision, collision );
			collisionList.add( collision );
		}
	}
	
	protected abstract class Collision {
		
		public abstract void doCollision();
		
	}
	
	protected class VehicleCollision extends Collision {
		private Vehicle veh1, veh2;
		
		public VehicleCollision( Vehicle veh1, Vehicle veh2 ) {
			this.veh1 = veh1;
			this.veh2 = veh2;
		}
				
		public void doCollision() {
			handler.handleCollision( sim, veh1, veh2 );
		}
		
		/* (non-Javadoc)
		 * @see java.lang.Object#equals(java.lang.Object)
		 */
		public boolean equals(Object obj) {
			if ( obj instanceof VehicleCollision ) {
				VehicleCollision collision = (VehicleCollision)obj;
				return (veh1 == collision.veh1 && veh2 == collision.veh2)
				||     (veh2 == collision.veh1 && veh1 == collision.veh2);
			}
			return false;
		}

		/* (non-Javadoc)
		 * @see java.lang.Object#hashCode()
		 */
		public int hashCode() {
			return veh1.hashCode() + veh2.hashCode();
		}

	}
	
	protected class FixedObjectCollision extends Collision {
		private Vehicle veh;
		private FixedObject fixedObj;
	
		public FixedObjectCollision( Vehicle veh, FixedObject fixedObj ) {
			this.veh = veh;
			this.fixedObj = fixedObj;
		}
			
		public void doCollision() {
			handler.handleCollision( sim, veh, fixedObj );
		}
	
		/* (non-Javadoc)
		 * @see java.lang.Object#equals(java.lang.Object)
		 */
		public boolean equals(Object obj) {
			if ( obj instanceof FixedObjectCollision ) {
				FixedObjectCollision collision = (FixedObjectCollision)obj;
				return (veh == collision.veh && fixedObj == collision.fixedObj);
			}
			return false;
		}

		/* (non-Javadoc)
		 * @see java.lang.Object#hashCode()
		 */
		public int hashCode() {
			return veh.hashCode() + fixedObj.hashCode();
		}

	}

}
