/*
 * Created on Nov 12, 2003
 *
 */
package proj1.nnet;

import java.util.*;

/**
 * @author john
 *
 */
public class NeuralNet {
	private List inputs = new ArrayList();
	private List neurons = new ArrayList();
	private List outputs = new ArrayList();
	private List connections = new ArrayList();
	
	public void add( Neuron n ) {
		neurons.add( n );
	}
	
	public void addInput( Neuron n ) {
		inputs.add( n );
	}
	
	public void addOutput( Neuron n ) {
		outputs.add( n );
	}
	
	public Neuron get( int i ) {
		return (Neuron)neurons.get( i );
	}
	
	public Neuron getInput( int i ) {
		return (Neuron)inputs.get( i );
	}
	
	public Neuron getOutput( int i ) {
		return (Neuron)outputs.get( i );
	}
	
	public int size() {
		return neurons.size();
	}
	
	public void add( Neuron input, float weight, Neuron output ) {
		connections.add( new Connection( input, output, weight ) );
	}
	
	public void reset() {
		for ( int i = 0; i < neurons.size(); i++ ) {
			((Neuron)neurons.get( i )).resetInput();
		}
	}
	
	public void update() {
		for ( int i = 0; i < connections.size(); i++ ) {
			((Connection)connections.get( i )).update();
		}
				
		for ( int i = 0; i < neurons.size(); i++ ) {
			((Neuron)neurons.get( i )).updateOutput();
		}
	}

}
