/*
 * Created on Nov 21, 2003
 *
 */
package proj1.gui;

import java.awt.*;
import javax.swing.Icon;

/**
 * @author john
 *
 */
public class SpeciesIcon implements Icon {
	private Color color = Color.blue;
	private int numSensorsGroups = 2;
	private double sensorAngle = Math.PI;

	public void setColor( Color color ) {
		this.color = color;
	}
	
	public Color getColor() {
		return color;
	}
	
	public int getNumSensorsGroups() {
		return numSensorsGroups;
	}
	
	public void setNumSensorsGroups( int numSensorsGroups ) {
		this.numSensorsGroups = numSensorsGroups;
	}
	
	public double getSensorAngle() {
		return sensorAngle;
	}
	
	public void setSensorAngle( double sensorAngle ) {
		this.sensorAngle = sensorAngle;
	}

	private void drawAngle( Graphics g, int x, int y, double angle ) {
		int x1 = x + getIconWidth()/2, 
		    y1 = y + getIconHeight()/2;
		int x2 = (int)(x1 + getIconWidth()*Math.cos( angle )/2), 
		    y2 = (int)(y1 + getIconHeight()*Math.sin( angle )/2);
		g.drawLine( x1, y1, x2, y2 );
	}

	/* (non-Javadoc)
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics, int, int)
	 */
	public void paintIcon(Component c, Graphics g, int x, int y) {
		g.setColor( color );
		g.fillOval( x, y, getIconWidth(), getIconHeight() );
		g.setColor( Color.black );
		g.drawOval( x, y, getIconWidth(), getIconHeight() );
		
		for ( int i = 0; i < numSensorsGroups; i++ ) {
			double angle = i*sensorAngle/numSensorsGroups - sensorAngle/2;
			drawAngle( g, x, y, angle );
		}
		drawAngle( g, x, y, sensorAngle/2 );
	}

	/* (non-Javadoc)
	 * @see javax.swing.Icon#getIconWidth()
	 */
	public int getIconWidth() {
		return 64;
	}

	/* (non-Javadoc)
	 * @see javax.swing.Icon#getIconHeight()
	 */
	public int getIconHeight() {
		return 64;
	}

}
