/*
 * Created on Nov 20, 2003
 *
 */
package proj1.gui;

import javax.swing.*;
import java.awt.*;

/**
 * @author john
 *
 */
public class OkCancelDialog extends JDialog {
	private boolean okPressed = false;

	public OkCancelDialog( JFrame parent, String title ) {
		super( parent, title, true );
		init();
	}

	public OkCancelDialog( JDialog parent, String title ) {
		super( parent, title, true );
		init();
	}
	
	private void init() {
		okPressed = false;
		getContentPane().setLayout( new BorderLayout( 10, 10 ) );
		
		JPanel buttonPanel = new JPanel();
		JButton okButton = new JButton( "Ok" );
		okButton.addActionListener( new ActionAdapter( this, "okClicked" ) );

		JButton cancelButton = new JButton( "Cancel" );
		cancelButton.addActionListener( new ActionAdapter( this, "cancelClicked" ) );

		buttonPanel.add( cancelButton );
		buttonPanel.add( okButton );

		getContentPane().add( buttonPanel, BorderLayout.SOUTH );

		getRootPane().setDefaultButton( okButton );
	}
	
	public boolean showOkCancel() {
		pack();
		centre();
		show();
		return okPressed;
	}
	
	private void centre() {
		Rectangle r = getParent().getBounds();
		Dimension d = getSize();
		int x, y;
	
		x = r.x + (r.width-d.width)/2;
		y = r.y + (r.height-d.height)/2;
	
		setLocation( x, y );
	}

	protected int extractInt( String text ) {
		try {
			Integer i = new Integer( text.trim() );
			return i.intValue();
		}
		catch( NumberFormatException e ) {
		}
		return -1;
	}

	protected boolean isInteger( String text ) {
		try {
			Integer i = new Integer( text.trim() );
			return true;
		}
		catch( NumberFormatException e ) {
		}
		return false;
	}

	protected boolean validateInteger( JTextField text ) {
		if ( !isInteger( text.getText() ) ) {
			text.requestFocus();
			return false;
		}
		return true;
	}
	
	protected double extractDouble( String text ) {
		try {
			Double d = new Double( text.trim() );
			return d.doubleValue();
		}
		catch( NumberFormatException e ) {
		}
		return Double.NaN;
	}
	
	protected boolean isDouble( String text ) {
		try {
			Double d = new Double( text.trim() );
			return true;
		}
		catch( NumberFormatException e ) {
		}
		return false;
	}

	protected boolean validateDouble( JTextField text ) {
		if ( !isDouble( text.getText() ) ) {
			text.requestFocus();
			return false;
		}
		return true;
	}
		
	protected boolean validateInput() {
		return true;
	}
	
	protected final void okClicked() {
		if ( validateInput() ) {
			okPressed = true;
			setVisible( false );
		}
		else {
			Toolkit.getDefaultToolkit().beep();
		}
	}

	protected final void cancelClicked() {
		okPressed = false;
		setVisible( false );
	}

}
