/*
 * Population.java
 *
 * Created on 11 November 2003, 12:46
 */

package proj1.evol;

import java.util.*;

/**
 *
 * @author  msc37jxm
 */
public class Population {
	private List adults = new ArrayList();
	private List juvenilles = new ArrayList();
	
	private String name = null;
	private double mutationRate = 0.5f;
	private double recombinationRate = 0.5f;
	
	
	/** Creates a new instance of Population */
	public Population( String name, double mutationRate, double recombinationRate ) {
		this.name = name;
		this.mutationRate = mutationRate;
		this.recombinationRate = recombinationRate;
	}
	
	public String getName() {
		return name;
	}
	
	public double getMutationRate() {
		return mutationRate;
	}
	
	public double getRecombinationRate() {
		return recombinationRate;
	}
	
	public int size() {
		return adults.size() + juvenilles.size();
	}
	
	public Phenotype get( int i ) {
		if ( i < adults.size() )
			return (Phenotype)adults.get( i );
		else
			return (Phenotype)juvenilles.get( i-adults.size() );
	}
	
	public void add( Phenotype individual ) {
		adults.add( individual );
	}
	
	public void addJuvenille( Phenotype juvenille ) {
		juvenilles.add( juvenille );
		//adults.add( juvenille );
		// TODO review need for juvenilles
	}
	
	public void promoteJuvenilles() {
		adults.addAll( juvenilles );
		juvenilles.clear();
	}

	public void remove( Phenotype individual ) {
		adults.remove( individual );
	}
	
	public Phenotype makeChild() {
		Phenotype parent1 = selectRankBased();
		Phenotype parent2 = selectRankBased();
				
		Genotype parent1Genotype = parent1.getGenotype();
		Genotype parent2Genotype = parent2.getGenotype();

		Genotype childGenotype = parent1Genotype.make();
		
		if ( Math.random() < recombinationRate )
			childGenotype.recombine( parent1Genotype, parent2Genotype );
		else
			childGenotype.copy( parent1Genotype );
			
		if ( Math.random() < mutationRate )
			childGenotype.mutate();
		
		Phenotype child = parent1.make( childGenotype );
		
		return child;
	}
	
	public float calculateAverageFitness() {
		float sum = 0.0f;
		for ( int i = 0; i < adults.size(); i++ ) {
			Phenotype individ = (Phenotype)adults.get( i );
			float fitness = individ.getFitness();
			sum += fitness;
		}
		return sum/adults.size();
	}
	
	public int calculateAverageAge() {
		int sum = 0;
		for ( int i = 0; i < adults.size(); i++ ) {
			Phenotype individ = (Phenotype)adults.get( i );
			int age = individ.getAge();
			sum += age;
		}
		return sum/adults.size();
	}
	
	public float getWorstFitness() {
		return selectWorst().getFitness();
	}
	
	public float getBestFitness() {
		return selectBest().getFitness();
	}
	
	public Phenotype selectWorst() {
		float worstFitness = Float.MAX_VALUE;
		Phenotype worst = null;
		for ( int i = 0; i < adults.size(); i++ ) {
			Phenotype individ = (Phenotype)adults.get( i );
			float fitness = individ.getFitness();
			if ( fitness < worstFitness ) {
				worstFitness = fitness;
				worst = individ;	
			}
		}
		return worst;
	}
	
	public Phenotype selectBest() {
		float bestFitness = -Float.MAX_VALUE;
		Phenotype best = null;
		for ( int i = 0; i < adults.size(); i++ ) {
			Phenotype individ = (Phenotype)adults.get( i );
			float fitness = individ.getFitness();
			if ( fitness > bestFitness ) {
				bestFitness = fitness;
				best = individ;	
			}
		}
		return best;
	}
	
	public Phenotype selectRandom() {
		if ( adults.size() == 0 ) return null;
		int index = (int)(Math.random()*adults.size());
		return get( index );
	}
	
	/** Select an individual using it's rank in the population. 
	 *  
	 **/
	public Phenotype selectRankBased() {
		Collections.sort( adults );
		double r = Math.random();
		int index = (int)(r*r*adults.size());
		return get( index );
	}
	
	/** Select an individual using scaled fitness proportional selection. 
	 *  (Scaled Roulette Wheel Sampling).
	 **/
	public Phenotype selectScaledRoulette() {
		float minimumFitness = Float.MAX_VALUE;
		float sum = 0.0f;
		
		for ( int i = 0; i < adults.size(); i++ ) {
			Phenotype individ = (Phenotype)adults.get( i );
			float fitness = individ.getFitness();
			minimumFitness = Math.min( minimumFitness, fitness );
			sum += fitness;
		}
		
		sum -= (adults.size()*minimumFitness);
		
		float threshold = (float)(Math.random()*sum);
		
		sum = 0.0f;
		
		for ( int i = 0; i < adults.size(); i++ ) {
			Phenotype individ = (Phenotype)adults.get( i );
			float fitness = individ.getFitness() - minimumFitness;
			sum += fitness;
			if ( sum >= threshold )
				return individ;
		}
		
		// just in case
		return selectRandom();
	}
	
}
