/*
 * Parameters.java
 *
 * Created on 18 November 2003, 13:01
 */

package proj1;

import java.util.*;
import java.io.*;

/**
 *
 * @author  msc37jxm
 */
public class Parameters {
	private Properties params = new Properties();
	
	/** Creates a new instance of Parameters */
	public Parameters() {
	}
	
	public String getParameter( String name, String defaultValue ) {
		if ( params.containsKey( name ) )
			return params.getProperty( name, defaultValue );
		params.put( name, defaultValue );
		return defaultValue;
	}
	
	public void setParameter( String name, String value ) {
		params.put( name, value );
	}

	public int getParameter( String name, int defaultValue ) {
		String str = getParameter( name, String.valueOf( defaultValue ) );
		try {
			return Integer.parseInt( str );
		}
		catch( NumberFormatException nfe ){}
		return defaultValue;
	}
	
	public void setParameter( String name, int value ) {
		setParameter( name, String.valueOf( value ) );	
	}

	public double getParameter( String name, double defaultValue ) {
		String str = getParameter( name, String.valueOf( defaultValue ) );
		try {
			return Double.parseDouble( str );
		}
		catch( NumberFormatException nfe ){}
		return defaultValue;
	}
	
	public void setParameter( String name, double value ) {
		setParameter( name, String.valueOf( value ) );	
	}
	
	public boolean getParameter( String name, boolean defaultValue ) {
		String str = getParameter( name, String.valueOf( defaultValue ) );
		return Boolean.valueOf( str ).booleanValue();
	}
	
	public void setParameter( String name, boolean value ) {
		setParameter( name, String.valueOf( value ) );	
	}
	
	public void save( OutputStream out ) throws IOException {
		params.store( out, "Simulation Parameters" );
	}

	public void load( InputStream in ) throws IOException {
		params.load( in );
	}
	
}
