/*
 * Created on Nov 4, 2003
 *
 */
package proj1;

import proj1.simulator.Brain;
import proj1.simulator.Effector;
import proj1.simulator.Sensor;

/**
 * @author john
 *
 */
public class HardwiredBrain implements Brain {
	float left, right;

	/* (non-Javadoc)
	 * @see proj1.simulator.Brain#receiveInputs(proj1.simulator.Sensor[])
	 */
	public void receiveInputs(Sensor[] sensors) {
		left = right = 0.0f;
		
		for ( int i = 0, j = sensors.length-1; i < j; i++, j-- ) {
			float l = sensors[ i ].getValue();
			float r = sensors[ j ].getValue();
			left  += l;
			right += r;
		}
		
		float d = (left-right) + (float)(0.1f*(0.5-Math.random()));
		
		float c = 0.5f;
		if ( left > 0.9f && right > 0.9f ) {
			c = -(c*left);
			d += (float)(0.25-Math.random());
		}
		
		left = c + d;
		right = c -d;
	}

	/* (non-Javadoc)
	 * @see proj1.simulator.Brain#computeOutputs(proj1.simulator.Effector[])
	 */
	public void computeOutputs(Effector[] effectors) {
		effectors[ 0 ].setOutput( left );
		effectors[ 1 ].setOutput( right );
	}

}
