/*
 * Created on Nov 27, 2003
 *
 */
package proj1;

import proj1.simulator.Color;
import java.io.*;
import java.util.*;

/**
 * @author john
 *
 */
public class DataDecoder {
	private Reader reader = null;
	private StreamTokenizer st = null;
	
	public DataDecoder( Reader reader ) {
		this.reader = reader;
		st = new StreamTokenizer( reader );
		st.resetSyntax();
		st.whitespaceChars( ' ', ' ' );
		st.whitespaceChars( '\t', '\t' );
		st.whitespaceChars( '\n', '\n' );
		st.eolIsSignificant( false );
		st.wordChars( ' ' +1, 255 );
		st.ordinaryChar( '=' );
		st.ordinaryChar( '{' );
		st.ordinaryChar( '}' );
		st.ordinaryChar( ',' );
		st.ordinaryChar( '(' );
		st.ordinaryChar( ')' );
		st.quoteChar( '\"' );
	}
	
	public void close() throws IOException {
		reader.close();
	}
	
	public Object decode( String name ) throws IOException {
		if ( st.nextToken() != StreamTokenizer.TT_WORD )
			throw new RuntimeException( "Unexpected token reading " + name + ", line " + st.lineno() );
		
		if ( !st.sval.equals( name ) )
			throw new RuntimeException( "Expected " + name + ".  Got " + st.sval + ", line " + st.lineno() );
		
		if ( st.nextToken() != '=' )
			throw new RuntimeException( "Unexpected token reading " + name + ", line " + st.lineno() );
		
		return readData();
	}
	
	public String decodeString( String name ) throws IOException {
		return decode( name ).toString();
	}
	
	public boolean decodeBoolean( String name ) throws IOException {
		return decode( name ).equals( Boolean.TRUE );
	}
	
	public int decodeInt( String name ) throws IOException {
		return ((Number)decode( name )).intValue();
	}
	
	public float decodeFloat( String name ) throws IOException {
		return ((Number)decode( name )).floatValue();
	}
	
	public double decodeDouble( String name ) throws IOException {
		return ((Number)decode( name )).doubleValue();
	}
	
	public float[] decodeFloatArray( String name ) throws IOException {
		List list = (List)decode( name );
		float[] arr = new float[ list.size() ];
		for ( int i = 0; i < arr.length; i++ )
			arr[ i ] = ((Number)list.get( i )).floatValue();
		return arr;
	}
	
	public Color decodeColor( String name ) throws IOException {
		return (Color)decode( name );
	}
	
	public Color[] decodeColorArray( String name ) throws IOException {
		List list = (List)decode( name );
		Color[] arr = new Color[ list.size() ];
		for ( int i = 0; i < arr.length; i++ )
			arr[ i ] = (Color)list.get( i );
		return arr;
	}
	
	private Object readData() throws IOException {
		switch( st.nextToken() ) {
				case StreamTokenizer.TT_NUMBER:
					return new Double( st.nval );
				case '\"':
					return st.sval;
				case StreamTokenizer.TT_WORD:
					if ( st.sval.equals( "RGB" ) ) {
						st.pushBack();
						return readColor();
					}
					else if ( st.sval.equals( "true" ) )
						return Boolean.TRUE;
					else if ( st.sval.equals( "false" ) )
						return Boolean.FALSE;
					else {
						try {
							return new Double( st.sval );
						}
						catch( NumberFormatException nfe ) {
							nfe.printStackTrace();
						}
					}
					break;
				case '{':
					st.pushBack();
					return readList();
		}
		throw new RuntimeException( "Unknown data type line " + st.lineno() );
	}
	
	private Color readColor() throws IOException {
		if ( st.nextToken() != StreamTokenizer.TT_WORD || !st.sval.equals( "RGB") )
			throw new RuntimeException( "Expected RGB to start color line " + st.lineno() );
		
		if ( st.nextToken() != '(' )
			throw new RuntimeException( "Expected ( line " + st.lineno() );
			
		Number r = (Number)readData();
		
		if ( st.nextToken() != ',' )
			throw new RuntimeException( "Expected , line " + st.lineno() );
		
		Number g = (Number)readData();
		
		if ( st.nextToken() != ',' )
			throw new RuntimeException( "Expected , line " + st.lineno() );
			
		Number b = (Number)readData();
		
		if ( st.nextToken() != ')' )
			throw new RuntimeException( "Expected ) line " + st.lineno() );
			
		return new Color( r.intValue(), g.intValue(), b.intValue() );
	}
	
	private List readList() throws IOException {
		List list = new ArrayList();
		
		if ( st.nextToken() != '{' )
			throw new RuntimeException( "Expected { line " + st.lineno() );
			
		while( st.nextToken() != '}' ) {
			st.pushBack();
			list.add( readData() );
			if ( st.nextToken() != ',' )
				st.pushBack();
		}
		
		return list;
		
	}

}
